/***************************************************************************
                          ksetiwatch.h  -  description
                             -------------------
    begin                : Fre Okt 22 17:39:47 CEST 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSETIWATCH_H
#define KSETIWATCH_H

#include <kmainwindow.h>

#include <qpixmap.h>

class KIconLoader;
class KTabCtl;
class KConfig;
class QListViewItem;
class QPopupMenu;
class Analysis;
class DataInfo;
class UserInfo;
class CompletedWUList;
class Options;
class About;
class DockWidget;
class SetiLoc;

class Ksetiwatch : public KMainWindow
{
Q_OBJECT

public:
  /** constructor */
  Ksetiwatch(const char* name=0);
  /** destructor */
  ~Ksetiwatch();
  bool startMinimized() {return startmin;}
  /**
   * Returns the corresponding SetiLoc entry from
	 * a QListView item in the Analysis list.
	 * @param list the ListView in question
	 * @param it the QListViewItem
	 * @return the SetiLoc entry, or 0 if it couldn't be found.
	 */
  static SetiLoc* getLocation(int list, QListViewItem* it);

protected:
	virtual void closeEvent(QCloseEvent *e);
	virtual void saveProperties(KConfig*);
	bool event(QEvent *e);
  /** Starts the SETI@home clients if the startup switch is on. */
  void startClients();
  /** No descriptions */
  void stopClients();

private:
	KConfig*         config;
	KIconLoader*     loader;
	KTabCtl*         ktb;
	Analysis*        ana;
	DataInfo*        di;
	UserInfo*        ui;
	CompletedWUList* cwu;
	Options*         opt;
	About*           abt;
	DockWidget*      ksdock;
	QPopupMenu*      dockrightpopup;
	bool             startmin;
	QPixmap          StarMap;

private slots:
	void saveConfig();
	void readConfig();
	void handleTabSelection(int);


protected slots: // Protected slots
  /** Toggles dock icon on or off when the user makes changes in the options. */
  void toggleIcon();
};
#endif
