/***************************************************************************
                          pulseplot.cpp  -  description
                             -------------------
    begin                : Mon Oct 23 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>

#include "pulseplot.h"

PulsePlot::PulsePlot(SetiLoc* loc, QWidget *parent, const char *name ) : SetiGraph(loc,true,false,parent,name)
{
// Make an array twice the size of the actual pulse data. Pulse data will be copied
// twice into that array.
pulseData.resize(1024);

// connect the SetiLoc signal to the new Gaussian slot of this widget.
location = loc;
connect(location, SIGNAL(newPulse(PulseScore)), this, SLOT(showNewPulseData(PulseScore)));

QString title;
title = i18n("Top Pulse for %1 (right-click for options)").arg(loc->description());
setCaption(title);
setBackgroundColor(black);
resize(350, 200);
setMinimumSize(150, 100);

setTextPosition(SetiGraph::TopRight);

// prepare data for display
showNewPulseData(location->pulseScore());
}

PulsePlot::~PulsePlot()
{
}

/////////////////////////////////////////////////////////////////////////////
void PulsePlot::showNewPulseData(PulseScore score)
{
	pulse = score;
	// convert int to double and make a copy in the upper 512 array elements
	for(int i=0;i<512;i++)
	  {
	  pulseData[i] = (double)pulse.data[i];	
    pulseData[i+512] = pulseData[i];
    }
	setCurve(pulseData);
	
  // generate the info text
  QString it;
  it.sprintf("power : %f\n"
             "mean  : %f\n"
             "period: %f\n"
             "score : %f",
             pulse.power,
             pulse.mean,
             pulse.period,
             pulse.score
             );
  setInfoText(it);

	repaint();
}

#include "pulseplot.moc"
