/***************************************************************************
                          tripletplot.h  -  description
                             -------------------
    begin                : Tue Oct 24 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRIPLETPLOT_H
#define TRIPLETPLOT_H

#include <setigraph.h>

/**
  *@author Gordon Machel
  */

class TripletPlot : public SetiGraph
{
   Q_OBJECT

public:
	TripletPlot(SetiLoc* loc, QWidget *parent=0, const char *name=0);
	~TripletPlot();

protected: // Protected attributes
  /** Stores the S@h location. */
  SetiLoc* location;
  /** This array stores the triplet data. */
  QArray<double> tripletData;
  /** A pointer to a structure containing the top triplet. */
  TripletScore triplet;

protected: // Protected methods
  /** Repaints this widget. */
  virtual void paintEvent(QPaintEvent* e);
  /** Draws a green marker at position @e index. */
  void drawPulseMarker(int index, QPainter* p);

protected slots: // Protected slots
  /** Updates the widget with new triplet data. */
  void showNewTripletData(TripletScore score);
};

#endif
