/***************************************************************************
                          userinfo.cpp  -  description
                             -------------------
    begin                : Tue Oct 26 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <kapp.h>
#include <klocale.h>

#include <qheader.h>

#include "userinfo.h"
#include "setiloc.h"

// extern globals
extern QList<SetiLoc> SetiList;
extern bool DRAWGRID;

/*------------------------------------------------------------------------ */
UserInfoListViewItem::UserInfoListViewItem(QListView* parent):QListViewItem(parent)
{
}

/*------------------------------------------------------------------------ */
UserInfoListViewItem::~UserInfoListViewItem()
{
}

/*------------------------------------------------------------------------ */
QString UserInfoListViewItem::key(int column, bool ascending) const
{
// return value must be static
static QString ret;
QString val;
double tmp;

if(column == 2)
	{
	val = text(column);
	tmp = val.toDouble();
	val.sprintf("%f", tmp);
	ret = val.rightJustify(32, '0');
	}
else if(column == 3 || column == 4)
	{
	int colon;
	int d(0), h(0), m(0), s(0);
	
	val = text(column);
	colon = val.contains(':');
	if(colon == 2)
		{
		sscanf(text(column), "%d:%d:%d", &h, &m, &s);
		}
	else if(colon == 3)
		{
		sscanf(text(column), "%dd:%d:%d:%d", &d, &h, &m, &s);
		}
	tmp = 86400*d + 3600*h + 60*m + s;
	ret.sprintf("%032d", (int)tmp);
	}
else
	{
	ret = text(column);
	}
	
return(ret);
}

/*------------------------------------------------------------------------ */
void UserInfoListViewItem::paintCell(QPainter* p, const QColorGroup& cg,
                                     int column, int width, int align)
{
QListViewItem::paintCell(p, cg, column, width, align);
if(DRAWGRID)
	{
	p->setPen( cg.midlight() );
	p->moveTo(0, height()-1);
	p->lineTo(width-1, height()-1);
	p->lineTo(width-1, 0);
  }
}


/*------------------------------------------------------------------------ */
UserInfo::UserInfo(QWidget* parent, const char* name) : QWidget(parent,name)
{
TableColumn uitc[] =  {
                      {i18n("Location"), -1, AlignLeft},
                      {i18n("Name"), -1, AlignLeft},
                      {i18n("WU Completed"), -1, AlignRight},
                      {i18n("Total CPU Time"), -1, AlignRight},
                      {i18n("Average CPU Time"), -1, AlignRight},
                      {i18n("Last Result"), 150, AlignRight},
                      {i18n("Register Time"), 150, AlignRight}
                      };

QListView_1= new popListView(this);
QListView_1->setShowSortIndicator(true);
QListView_1->setPopupStyle(popListView::ShowAnywhere);
QListView_1->move(5,1);

for(int i=0;i<7;i++)
	{
	QListView_1->addColumn(uitc[i].text,-1);
	if(uitc[i].width != -1) QListView_1->setColumnWidth(i, uitc[i].width);  	
  QListView_1->setColumnAlignment(i, uitc[i].alignment);
  }

connect(QListView_1->header(), SIGNAL(sectionClicked(int)),
                         this, SLOT(toggleSorting(int)));
sortingorder = true;
  	
refreshList();
}

/*------------------------------------------------------------------------ */
UserInfo::~UserInfo()
{
}

/*------------------------------------------------------------------------ */
void UserInfo::resizeEvent(QResizeEvent *e)
{
QListView_1->resize(this->width()-10, this->height()-5);
}
	
/*------------------------------------------------------------------------ */
void UserInfo::refreshList()
{
SetiLoc *loc;

for(loc=SetiList.first(); loc != 0; loc=SetiList.next())
	{
	if(loc->item(SetiLoc::UserInfoList) == 0)
	  loc->addItem(SetiLoc::UserInfoList, QListView_1);
  else
    loc->item(SetiLoc::UserInfoList)->setText(0, loc->description());
	}
}

/*------------------------------------------------------------------------ */
void UserInfo::toggleSorting(int column)
{
sortingorder = !sortingorder;
QListView_1->setSorting(column, sortingorder);
}

#include "userinfo.moc"
