/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qlayout.h>
#include <qfileinfo.h>
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kbuttonbox.h>
#include "misc.h"
#include "cvsprogressdlg.h"

#include "annotatedlg.h"
#include "annotatedlg.moc"


#if QT_VERSION < 200
#define QCString QString
#endif


AnnotateDialog::Options *AnnotateDialog::options = 0;


AnnotateDialog::AnnotateDialog(QWidget *parent, const char *name)
#if QT_VERSION < 200
    : QDialog(parent, name)
#else
    : QDialog(parent, name,
              WStyle_Customize|WStyle_NormalBorder|WStyle_Title|WStyle_MinMax)
#endif
{
    QBoxLayout *layout = new QVBoxLayout(this, 10);

    annotate = new AnnotateView(this);
#if 0
    annotate->setMinimumSize(annotate->sizeHint());
#endif
    layout->addWidget(annotate, 10);

    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    frame->setMinimumHeight(frame->sizeHint().height());
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    connect( buttonbox->addButton(i18n("&Close")), SIGNAL(clicked()),
	     SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    QFontMetrics fm(fontMetrics());
    setMinimumSize(fm.width("0123456789")*12,
		   fm.lineSpacing()*30);
    layout->activate();

    if (options)
        resize(options->size);
}


void AnnotateDialog::done(int res)
{
    if (!options)
        options = new Options;
    options->size = size();

    QDialog::done(res);
    delete this;
}


void AnnotateDialog::loadOptions(KConfig *config)
{
    if (!config->readEntry("Customized"))
        return;

    options = new Options;
    options->size = config->readSizeEntry("Size");
}


void AnnotateDialog::saveOptions(KConfig *config)
{
    if (!options)
        return;

    config->writeEntry("Customized", true);
    config->writeEntry("Size", options->size);
}


bool AnnotateDialog::parseCvsAnnotate(QString sandbox, QString repository,
                                      QString filename, QString rev)
{
    setCaption("CVS Annotate: " + filename);

    QString cmdline = cvsClient() + " annotate ";
    
    if (!rev.isEmpty())
	{
	    cmdline += " -r ";
	    cmdline += rev;
	}
    cmdline += " ";
    cmdline += quote(filename);
    // Hack because the string Annotations for blabla is
    // print to stderr even with option -Q. Arg!
    cmdline += " 2>&1";

    CvsProgressDialog l("Annotate", this);
    l.setCaption("CVS Annotate");
    if (!l.execCommand(sandbox, repository, cmdline, "annotate"))
        return false;

    QCString str;
    for (int i = 0; i < 2; ++i)
        l.getOneLine(&str);
    
    while ( l.getOneLine(&str) )
        {
	    QString rev = str.left(13).stripWhiteSpace();
	    QString author = str.mid(14, 8).stripWhiteSpace();
	    QString date = str.mid(23, 9);
	    QString line = str.mid(35, str.length()-35);
	    annotate->addLine(rev, author, date, line);
	}

    return true; // successfull
}


// Local Variables:
// c-basic-offset: 4
// End:
