/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _LOGLIST_H_
#define _LOGLIST_H_

#include <qlistview.h>
#include <qheader.h>

#include <iostream.h>
class LogListViewItem : public QListViewItem
{
public:
    
    LogListViewItem(QListView *list, QString branch, QString rev, QString author,
		     QString date, QString comment, QString taglist);

#if QT_VERSION >= 200
    virtual QString key (int column, bool) const;
#else
    virtual const char *key (int column, bool) const;
#endif
private:
    static QString truncateLine(QString s);
    static QString extractOrdinaryTags(QString s);
};


class LogListView : public QListView
{
    Q_OBJECT
    
public:
    LogListView( QWidget *parent=0, const char *name=0 );
    
    void addRevision(QString branch, QString rev, QString author,
		     QString date, QString comment, QString taglist);
    void setSelectedPair(QString selectionA, QString selectionB);
    
#if 0
    virtual QSize sizeHint() const
      { 
      QSize s = QListView::sizeHint();
      cout << "sizeHint: " << s.width() << "," << s.height() << endl;
      return QSize(s.width(), header()->sizeHint().height()+20);
      }
#endif

signals:
    void revisionClicked(QString rev, bool rmb);

protected:
#if QT_VERSION >= 200
    virtual void contentsMousePressEvent(QMouseEvent *e);
#else
    virtual void mousePressEvent(QMouseEvent *e);
#endif
    virtual void keyPressEvent(QKeyEvent *e);
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
