/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _REPOSITORYDLG_H_
#define _REPOSITORYDLG_H_

#include <qdialog.h>
#include <qlineedit.h>
#include <kconfig.h>

class QListView;


class RepositoryDialog : public QDialog
{
    Q_OBJECT

public:
    
    RepositoryDialog( QWidget *parent=0, const char *name=0 );

    void readConfigFile();
    void readCvsPassFile(); 

    static void loadOptions(KConfig *config);
    static void saveOptions(KConfig *config);

protected slots:
    void slotAddClicked();
    void slotRemoveClicked();
    void slotLoginClicked();
    void slotLogoutClicked();

protected:
    virtual void done(int r);
    
private:
    struct Options {
        QSize size;
    };
    static Options *options;

    QListView *repolist;
};


class AddRepositoryDialog : public QDialog
{
    Q_OBJECT

public:
    
    AddRepositoryDialog( QWidget *parent=0, const char *name=0 );

    QString repository()
        { return repo_edit->text(); }
    QString rsh()
        { return rsh_edit->text(); }
    
    static void loadOptions(KConfig *config);
    static void saveOptions(KConfig *config);

protected slots:
    void repoChanged();
    
protected:
    virtual void done(int r);
    
private:
    struct Options {
        QSize size;
    };
    static Options *options;

    QLineEdit *repo_edit;
    QLineEdit *rsh_edit;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
