/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef HEADEREDITOR_H
#define HEADEREDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class Catalog;
class QMultiLineEdit;

class HeaderEditor : public KDialogBase
{
   Q_OBJECT
public:
   /**
   * constructor for the HeaderEditor
   * @param cat The Catalog from which the header is edited
   */
   HeaderEditor(Catalog* cat,const char* name=0);
   virtual ~HeaderEditor();

   bool isModified();

public slots:
   void readHeader();

protected slots:

   /** update button */
   virtual void slotUser1();
   virtual void slotCancel();
   virtual void slotOk();
   virtual void slotDefault();

private:
   Catalog* _catalog;
   QMultiLineEdit* _editor;
};

#endif // HEADEREDITOR_H
