//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <kapp.h>
#include <kmessagebox.h>
#include <qstrlist.h>

#include "widgets.h"
#include "kinputline.h"
#include "ktextbox.h"
#include "ktable.h"


int convert(const QString &val, int def)
{
  bool ok;
  int result = val.toInt(&ok);
  if (!ok)
    result = def;
  return result;    
}


QWidget *infoBox(QString title, QString text)
{
  QWidget *result = new QWidget();

  KMessageBox::information(result, text, title);
  if (result)
    result->show();

  return result;
}


int inputBox(QWidget *parent, int width, QString title, QString text, QString init, QString &result)
{
  int code=0;

  result = init;

  KInputLine *dlg = new KInputLine(parent, "", TRUE, width, text, init);

  if (dlg)
  {  
    dlg->setCaption(title);
    code = dlg->exec();
    result = dlg->getText();
  }

  return code;  
}


void textBox(QWidget *parent, int width, int height, QString title, QString file)
{
  KTextBox *dlg = new KTextBox(parent, 0, TRUE, width, height, file);

  if (dlg)
  {
    dlg->setCaption(title);
    dlg->exec();
  }
}


int menuBox(QWidget *parent, int width, int menuheight, QString title, QString text, QStrList args, int index, QString &result)
{
  int code = 0;

  result = "";

  KMenuTable *box = new KMenuTable(width,menuheight,text,parent);

  if (box)
  {
    box->setCaption(title);
 
    for (unsigned int i=index; i+1<args.count(); i += 2) {
        box->insertItem(args.at(i+1));
    }

    code = box->exec();
  
    result = args.at((box->getItem()*2)+index);
  }

  return code;
}


int checkList(QWidget *parent, int width, int menuheight, QString title, QString text, QStrList args, int index, bool separateOutput, QStrList &result)
{
  int code=0;
  QStrList entries, tags;
  unsigned int i;
  QString rs;

  result.clear();  

  KCheckTable *box = new KCheckTable(width,menuheight,text,parent);
  
  if (box)
  {
    QListBox &table = box->getTable();

    box->setCaption(title);
 
    for (i=index; i+2<args.count(); i += 3) {
      tags.append(args.at(i));
      entries.append(args.at(i+1));
    }

    table.insertStrList(&entries);
    table.setMultiSelection(TRUE);
    table.setCurrentItem(0); // This is to circumvent a Qt bug

    for (i=0; index+i+2<args.count(); i += 3) {
      table.setSelected(i/3,strcmp(args.at(i+2+index),"on")==0);
    }

    code = box->exec();

    if (separateOutput) {
      for (i=0; i<table.count(); i++)
        if (table.isSelected(i))
          result.append(tags.at(i));
    } else {
      for (i=0; i<table.count(); i++)
        if (table.isSelected(i))
          rs += QString("\"") + tags.at(i) + "\" ";
      result.append(rs);
    }
  }
}


int radioBox(QWidget *parent, int width, int menuheight, QString title, QString text, QStrList args, int index, QString &result)
{
  int code=0;
  QStrList entries, tags;
  unsigned int i;

  result = "";

  KCheckTable *box = new KCheckTable(width,menuheight,text,parent);
  
  if (box)
  {
    QListBox &table = box->getTable();

    box->setCaption(title);
 
    for (i=index; i+2<args.count(); i += 3) {
      tags.append(args.at(i));
      entries.append(args.at(i+1));
    }

    table.insertStrList(&entries);

    for (i=0; index+i+2<args.count(); i += 3) {
      table.setSelected(i/3,strcmp(args.at(i+2+index),"on")==0);
    }

    code = box->exec();
    result = tags.at(table.currentItem());    
  }
  
  return code;
}



