/* -------------------------------------------------------------

   toplevel.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@bigfoot.com>
   (C) by Matthias Hlzer 1998

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   QueryCombo   Provides an additional signal (return key pressed)
   
   TopLevel   The toplevel widget of Kdict.
   
 ------------------------------------------------------------- */

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include <qtimer.h>
#include <kmainwindow.h>

class QSplitter;

class KToggleAction;

class DictLabelAction;
class DictComboAction;
class DictButtonAction;
class DictToolBarPopupAction;
class MatchViewWidget;
class QueryView;
class OptionsDialog;
class DbSetsDialog;


class TopLevel : public KMainWindow
{
  friend QueryView;

  Q_OBJECT
  
public:

  TopLevel();
  ~TopLevel();

  void normalStartup();             // called when started without commandline parameters

public slots:

  void define(const QString &query);
  void defineClipboard();

  void match(const QString &query);
  void matchClipboard();

private:

  void setupActions();
  void setupStatusBar();
  void recreateGUI();

  void addCurrentInputToHistory();  // add text in the query-combobox to the history

private slots:

  void clearInput();                // erase text in query-combobox

  void doDefine();                  // define text in the combobox
  void doMatch();                   // match text in the combobox

  void stopClients();
  
  void buildHistMenu();
  void queryHistMenu();             // process a query via the history menu
  void clearQueryHistory();

  void StratDbChanged();
  void dbInfoMenuClicked();
  void databaseSelected(int num);

  void enableCopy(bool selected);
  void enablePrintSave();

  void clientStarted(const QString &message);
  void clientStopped(const QString &message);
  void resetStatusbar();
  void renderingStarted();
  void renderingStopped();

  void newCaption(const QString&);

  void toggleStatusbar();
  void toggleToolbar();
  void toggleMatchListShow();
  void toggleMatchListSwallow();
  void saveMatchViewSize();
  void adjustMatchViewSize();

  void slotConfKeys();
  void slotConfToolbar();
  
  void showSetsDialog();
  void hideSetsDialog();
  void setsChanged();
  
  void showOptionsDialog();
  void hideOptionsDialog();
  void optionsChanged();

private:

  KAction *actSave, *actPrint, *actStartQuery, *actStopQuery, *actCopy;
  KToggleAction *actToggleToolbar, *actToggleStatusbar, *actShowMatchList, *actSwallowMatchList;
  DictLabelAction *actQueryLabel, *actDbLabel;
  DictComboAction *actQueryCombo, *actDbCombo;
  DictButtonAction *actDefineBtn, *actMatchBtn;
  QList<KAction> historyActionList, dbActionList;
  DictToolBarPopupAction *actBack, *actForward;

  QSplitter *splitter;              // widgets....
  QueryView *resultView;        
  MatchViewWidget *matchView;
  OptionsDialog *optDlg;
  DbSetsDialog *setsDlg;

  QTimer resetStatusbarTimer;
  int stopRef;                      // remember how many "clients" are running
};

#endif
