/***************************************************************************
                           algo_idea.cpp  -  IDEA algorithm
                                -------------------

    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr

 This file is the code need to add the IDEA encryption algorithm support to
 KFileCoder. IDEA is a hard 128 bits encryption algorithm written by
 Richard De Moliner <demoliner@isi.ee.ethz.ch>. You can read "idea.c" to have
 more details about this algorithm
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>

#include <qfileinfo.h>

#include <kmessagebox.h>

#include "kfilecoder.h"
#include "algo_pc1.h"
#include "algo_idea.h"
#include "idea.h"

// ===========================================================================================================================
int addFileAlgoIdea(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToAdd, FILE *fArchive, BYTE *cHashControl, QWORD *qwCompressedFileSize, QWORD *qwEncodedFileSize)
{	
	QString strMess;
	short int cCurChar;
	int iFor;
	QFileInfo fi;
	DWORD dwHashPos;
	DWORD z, end, dwCount;
	int nRes;

	// Idea variables
	BYTE cBuffer[256];
	Idea_Key ideaKey;
	int nBytesRead;
	int i;
	
	// PC1 variables
	UINT pcSi,pcX1a2, pcX1a0[8], pcI, pcInter, pcCfc, pcCfd;
	BYTE pcKey[ENCODING_LEN+1];
	
	// Calculate the IDEA key from the 16 bytes hash key
	Idea_ExpandUserKey((UINT *)cPassword, ideaKey);
	
	// Initializations
	memset(cHashControl, 0, ENCODING_LEN);
	*qwCompressedFileSize = 0;
	*qwEncodedFileSize = 0;	

	nBytesRead = 0L;
	dwHashPos = 0L;

	// encode data
	while( (nBytesRead = fread(cBuffer, 1, Idea_dataSize, fFileToAdd)) > 0)
	{	(*qwCompressedFileSize) += nBytesRead;
		(*qwEncodedFileSize) += Idea_dataSize; // a full block must be encoded
	
		// encode with IDEA
		if (nBytesRead < Idea_dataSize) // if not a full 16 bytes block
			memset(cBuffer+nBytesRead, 0, Idea_dataSize-nBytesRead); // zero bytes which are not read
		
		Idea_Crypt((UINT*)cBuffer, (UINT*)cBuffer, ideaKey);
		
		// update the hash control table
		for (i=0; i < Idea_dataSize; i++)
		{
			cHashControl[dwHashPos] ^= cBuffer[i];

    	dwHashPos++;
    	if (dwHashPos >= ENCODING_LEN)
    		dwHashPos = 0;
    }    	

    errno = 0;
		nRes = fwrite(cBuffer, Idea_dataSize, 1, fArchive);
		if (nRes != 1)
   	{	strMess.sprintf(i18n("Can't add <b>%s</b> to archive: Error %s"), szFilename, strerror(errno));
   		KMessageBox::error (wWin, strMess);
			return ERROR_FAILED;
		}
	}

	// encode the hash control table
	memcpy(pcKey, cPassword, ENCODING_LEN);
	end = (ENCODING_LEN+1)*ENCODING_LEN;
	
	// PC1 Init
	pcSi=0;
	pcX1a2=0;
	pcI=0;

	for (z=1; z <= end; z++)
	{
		cCurChar = cHashControl[dwHashPos];

		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = random byte

		for (dwCount = 0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHashControl[dwHashPos] ^= cCurChar;

		dwHashPos++;
		if (dwHashPos >= ENCODING_LEN)
			dwHashPos = 0;
	}
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;
	
	return ERROR_SUCCESS;
}

// ===========================================================================================================================
int extractFilesAlgoIdea(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToDecode, FILE *fArchive, BYTE *cHashControl, QWORD qwCompressedFileSize, QWORD qwEncodedFileSize)
{
	QString strMess;
	int cCurChar;
	int iFor; // for(;;)
	DWORD dwHashPos;
	DWORD dwCount, end, z;
	DWORD dwBytesToWrite;
	int nRes;
	
	// Idea variables
	BYTE cBuffer[256];
	Idea_Key ideaKey;
	int i;
	
	// PC1 variables
	UINT pcSi,pcX1a2, pcX1a0[8], pcI, pcInter, pcCfc, pcCfd;
	BYTE pcKey[ENCODING_LEN+1];
	
	// Calculate the IDEA key from the 16 bytes hash key
	Idea_ExpandUserKey((UINT *)cPassword, ideaKey);
	Idea_InvertKey(ideaKey, ideaKey); // decoding = !encoding;
	
	// Initializations
	memset(cHashControl, 0, ENCODING_LEN);
	dwHashPos = 0L;
	QWORD qwCount=0L;
	
	// encode data
	while(qwCount < qwEncodedFileSize)
	{
		// read bytes from archive
	 	nRes = fread(cBuffer, 1, Idea_dataSize, fArchive);
		if (nRes != Idea_dataSize)
   	{	strMess.sprintf(i18n("Can't extract <b>%s</b> from archive: Error %s"), szFilename, strerror(errno));
   		KMessageBox::error (wWin, strMess);
			return ERROR_FAILED;
		}
		qwCount += Idea_dataSize;
				
		// update the hash control table
		for (i=0; i < Idea_dataSize; i++)
		{
			cHashControl[dwHashPos] ^= cBuffer[i];
    	dwHashPos++;
    	if (dwHashPos >= ENCODING_LEN)
    		dwHashPos = 0;
    }    	
	 	
	 	// decode with IDEA
		Idea_Crypt((UINT*)cBuffer, (UINT*)cBuffer, ideaKey);
		
		// If this is the last block, it may not be full
		if (qwCount > qwCompressedFileSize)
			dwBytesToWrite = qwCompressedFileSize % Idea_dataSize;
		else
			dwBytesToWrite = Idea_dataSize;
					
		if (szFilename && fFileToDecode) // if these variables are NULL, it's only a test ==> do not write anything
		{	nRes = fwrite(cBuffer, 1, dwBytesToWrite, fFileToDecode);
			if (nRes != (int)dwBytesToWrite)
			{	strMess.sprintf(i18n("Can't write file <b>%s</b>: Error %s"), szFilename, strerror(errno));
				KMessageBox::error (wWin, strMess);
				return ERROR_FAILED;
			}
		}

	}

	// encode the hash control table
	memcpy(pcKey, cPassword, ENCODING_LEN);
	end = (ENCODING_LEN+1)*ENCODING_LEN;

	// PC1 Init
	pcSi=0;
	pcX1a2=0;
	pcI=0;

	for (z=1; z <= end; z++)
	{
		cCurChar = cHashControl[dwHashPos];

		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = random byte

		for (dwCount = 0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHashControl[dwHashPos] ^= cCurChar;

		dwHashPos++;
		if (dwHashPos >= ENCODING_LEN)
			dwHashPos = 0;
	}
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;

	return ERROR_SUCCESS;
}

