/***************************************************************************
                          kfilereplace.h  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILEREPLACE_H
#define KFILEREPLACE_H 
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include General Linux
#include <pthread.h>

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

// application specific includes
#include "kfilereplaceview.h"
#include "kfilereplacedoc.h"
#include "resource.h"

// Global Thread data
extern pthread_t g_threadReplace;
extern bool g_bThreadRunning;
extern bool g_bThreadMustStop;
extern int g_nFilesRep;

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KFileReplaceView is
  * created which creates your view.
  */
class KFileReplaceApp : public KTMainWindow 
{
  Q_OBJECT

public:
  KFileReplaceApp();
  ~KFileReplaceApp();
  void initMenuBar();
  void initToolBar();
  void initStatusBar();
  void initView();
  void saveOptions();
  void readOptions();
  void enableCommand(int id_, bool bState);
	void UpdateCommandsAccess();
	void ShowResultList(bool bState);
  bool queryExit();

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  void statusCallback(int id_);
  void slotFileNewWindow();
  void slotFileReplace();
	void slotFileSaveResults();
	void slotFileStop();
  void slotFileInfo();
  void slotFileOpen();
	void slotParentDirectoryOpen();
  void slotFileDelete();
  void slotFileQuit();
  void slotViewToolBar();
  void slotViewStatusBar();
  void slotStatusMsg(const char *text);
  void slotStatusHelpMsg(const char *text);
	void closeEvent ( QCloseEvent *);
	void slotHelpWebSite();
	void slotHelpAbout();
	void resizeEvent( QResizeEvent * );	
	void timerEvent(QTimerEvent *);

	public:
		KFileReplaceView *GetView() { return view; }
		bool IsDateValid(char *szDate);

	private:
 		QPopupMenu *file_menu;
  	QPopupMenu *view_menu;
  	QPopupMenu *help_menu;

		bool m_bViewToolbar;
  	bool m_bViewStatusbar;

  	KMenuBar::menuPosition menu_bar_pos;
  	KToolBar::BarPosition tool_bar_pos;

  	KFileReplaceView *view;
  	KFileReplaceDoc *doc;


};
 
#endif // KFILEREPLACE_H
 
 
 
 
 
 
 
 











































