/***************************************************************************
                          kbswitchapp.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBSWITCHAPP_H
#define KBSWITCHAPP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kuniqueapp.h>
#include <ksystemtray.h>

#include "kbgroup.h"
#include "kbswitchtrayicon.h"
#include "kbconfig.h"
#include "xkeyboard.h"

/**
  *@author Leonid Zeitlin
  */

class KBSwitchApp : public KUniqueApplication  {
  Q_OBJECT
public: 
	KBSwitchApp();
	~KBSwitchApp();
protected: // Protected methods
  /** No descriptions */
  bool x11EventFilter(XEvent *e);
private: // Private attributes
  /**  */
  bool force_group_selection;
  bool toggle_mode;
  int toggle_groupno_new;
  int toggle_groupno_old;
  XKeyboard xkb;
  /**  */
  KBSwitchTrayIcon * trayicon;
  /** No descriptions */
  KBConfig *kbconf;
private: // Private methods
  /** Update the tray icon to show the flag corresponding to the current keyboard group */
  void updateIcon(int groupno);
  /** No descriptions */
  void internalToggleGroups();
  /** No descriptions */
  void forceSelectGroup(int groupno);
  /** No descriptions */
  int getNextGroup(int groupno) {
    return groupno >= kbconf->groupCount() - 1 ? 0 : groupno + 1;
  }
private slots: // Private slots
  /** No descriptions */
  void slotGroupSelected(int groupno);
  /** No descriptions */
  void slotSelectNextGroup();
  /** No descriptions */
  void slotPreferences();
  /** No descriptions */
  void slotKBConfChanged();
};

#endif
