/***************************************************************************
                          xkeyboard.cpp  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xkeyboard.h"

#include <qwindowdefs.h>
#include <kdebug.h>
#include <klocale.h>

XKeyboard *XKeyboard::m_self = 0;

XKeyboard::XKeyboard(){
  Display *display = qt_xdisplay();
  int opcode, errorBase, major = XkbMajorVersion, minor = XkbMinorVersion;

  m_self = this;

  // check the library version
  if (!XkbLibraryVersion(&major, &minor)) {
    kdWarning() << i18n("This program was built against XKB extension library\n"
      "version %1.%2, but is run with the library version %3.%4.\n"
      "This may cause various problems and even result in a complete\n"
      "failure to function\n").arg(XkbMajorVersion).arg(XkbMinorVersion).arg(major).arg(minor);
  }

  // initialize the extension
  if (!XkbQueryExtension(display, &opcode, &m_event_code, &errorBase, &major, &minor)) {
    kdError() << i18n("The X Server does not support a compatible XKB extension.\n"
      "Either the server is not XKB-capable or the extension was disabled.\n"
      "This program will start anyway, but most likely will fail\n");
  }
  // register for XKB events
  XkbSelectEventDetails(display, XkbUseCoreKbd, XkbStateNotify,
    XkbAllStateComponentsMask, XkbGroupStateMask);

  // retrieve the number of keyboard groups
  XkbDescRec xkb;

  memset(&xkb, 0, sizeof(xkb));
  XkbGetControls(display, XkbGroupsWrapMask, &xkb);
  m_numgroups = xkb.ctrls->num_groups;
  XkbFreeControls(&xkb, XkbGroupsWrapMask, 1);
}

XKeyboard::~XKeyboard(){
}

/** Determine if the given XEvent e is an XKB event with type XkbStateNotify.
  * If so, newgroupno will return the new keyboard group #.
  * In other words, return value of true means that this XEvent tells us
  * that the user just switched the keyboard group to the new value
  * newgroupno */
bool XKeyboard::isXkbStateNotifyEvent(XEvent *e, int *newgroupno){
  bool ret = false;
  if (e->type == m_event_code) {
    XkbEvent *kb_ev = (XkbEvent *) e;
    if (kb_ev->any.xkb_type == XkbStateNotify) {
      ret = true;
      *newgroupno = kb_ev->state.group;
    }
  }
  return ret;
}

/** Set the current keyboard group to the given groupno */
void XKeyboard::setKbdGroup(int groupno){
  XkbLockGroup(qt_xdisplay(), XkbUseCoreKbd, groupno);
}

extern "C" {
  static int IgnoreXError(Display *, XErrorEvent *) {
    return 0;
  }
}

/** Get the names of the currently configured keyboard groups */
void XKeyboard::getGroupNames(QStringList &list){
  XkbDescRec xkb;
  Display *display = qt_xdisplay();
  char *names[XkbNumKbdGroups];

  memset(&xkb, 0, sizeof(xkb));
  XkbGetNames(display, XkbGroupNamesMask, &xkb);
  memset(names, 0, sizeof(char *) * XkbNumKbdGroups);
  // XGetAtomNames below may generate BadAtom error, which is not a problem.
  // (it may happen if the name for a group was not defined)
  // Thus we temporarily ignore X errors
  XErrorHandler old_handler = XSetErrorHandler(IgnoreXError);
  XGetAtomNames(display, xkb.names->groups, m_numgroups, names);
  // resume normal X error processing
  XSetErrorHandler(old_handler);
  for (int i = 0; i < m_numgroups; i++) {
    if (names[i]) {
      list.append(names[i]);
      XFree(names[i]);
    }
    else list.append(QString::null);
  }
  XkbFreeNames(&xkb, XkbGroupNamesMask, 1);
}

XKeyboard * XKeyboard::self()
{
  return m_self;
}

/** return the current keyboard group index */
int XKeyboard::getGroupNo(){
  XkbStateRec rec;
  XkbGetState(qt_xdisplay(), XkbUseCoreKbd, &rec);
  return (int) rec.group;
}
