/***************************************************************************
                          batch.cpp  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "batch.h"
#include <qdatetime.h>
#include "info.h"

Batch::Batch(bool b){
	gui = b;
  setContinueAfterError(false);
	procList = new QList<ABProcess>;
	procList -> setAutoDelete(true);
	
	groupList = new QList<FileGroupBase>; // NO AUTODELETE!!!

	file.setName(dataDir() + "log");
	file.open(IO_WriteOnly | IO_Append);
	log.setDevice( &file );
}

Batch::~Batch(){
	delete procList;
	delete groupList;
}

void Batch::append(ABProcess * p, FileGroupBase * g){
	procList -> append(p);
	groupList -> append(g);
}

void Batch::start(){
	cntr = 0;
	startProcess(gui);
}

void Batch::startProcess(bool g){
	QDateTime t;
	t = t.currentDateTime();
	log << t.toString() << "  ";
	log << group(cntr) -> name() << " ";
	log << "ps: " << procList -> at(cntr) -> name() << "  ";
	log << "tot files: " << group(cntr)  -> numMarked() << "  ";
	log << "tot size: " << group(cntr) -> sizeMarked() << "\n";
	if (g){
		process(cntr) -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	  connect(process(cntr), SIGNAL(processExited(KProcess *)),SLOT(slotCont()));
	}
	else{
		process(cntr) -> start(KProcess::Block,KProcess::AllOutput);
		slotCont();
	}	
}

void Batch::slotCont(){
	emit processExited();
	if (!process(cntr) -> error().isEmpty()){
		log << "Error:\n";
		log << process(cntr) -> std_err;
		log << "\n";
		if (!continueAfterError())
			cntr = procList -> count(); // batch doesn't continue after error in previous process
	}
	cntr++;
	if (cntr < count())
		startProcess(gui);
	else
		emit batchExited();
}

bool Batch::error(){
	bool b = false;
	for (uint i = 0; i < count(); i++)
		if (!process(i) -> error().isEmpty())
			b = true;
	return b;
}

