/***************************************************************************
                          groupviewwidget.cpp  -  description
                             -------------------
    begin                : Wed Nov 8 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "groupviewwidget.h"

#include <stdlib.h>
#include <qtooltip.h>
#include <kapp.h>
#include <kmessagebox.h>
#include <kstddirs.h>
#include <kurlpixmapprovider.h>
#include <krun.h>

#include <iostream.h>

GroupViewWidget::GroupViewWidget(GroupManager * gm, QWidget *parent, const char *name) : GroupViewBase(parent,name) {
	groupManager = gm;
	groupManager -> stopScheduling();

	rpmItem = new RPMItem(groupManager, this);
	udgItem = new UDGItem(groupManager, this);
	insItem = new INSItem(groupManager, this);

	ListView1 -> setColumnWidth(0,180);
 	ListView1 -> setColumnWidth(1,25);
 	ListView1 -> setColumnWidth(2,70);
	ListView1 -> setColumnWidth(3,70);
	ListView1 -> setColumnWidth(4,70);
 	ListView1 -> setColumnWidth(5,70);
	ListView1 -> setColumnWidth(6,70);
	ListView1 -> setColumnWidth(7,25);
	ListView1 -> setColumnAlignment(2,2);
	ListView1 -> setColumnAlignment(3,2);
 	ListView1 -> setColumnAlignment(4,2);
	ListView1 -> setColumnAlignment(5,2);
	ListView1 -> setColumnAlignment(6,2);
	ListView1 -> setColumnWidthMode(0,QListView::Manual);
	ListView1 -> setAllColumnsShowFocus (true);

  ABLabel1 -> setFrameStyle(QFrame::Panel | QFrame::Sunken);

	connect(PushButton2,SIGNAL(clicked()),SLOT(slotSelectAll()));
	connect(PushButton3,SIGNAL(clicked()),SLOT(slotDeSelectAll()));
	connect(PushButton4,SIGNAL(clicked()),SLOT(slotCleanup()));                                    		
	connect(PushButton5,SIGNAL(clicked()),SLOT(slotHelp()));

	connect(FileListView1,SIGNAL(fileSelectionChanged(FileGroupBase*)),SLOT(slotFileSelectionChanged(FileGroupBase*)));
	connect(FileListView1,SIGNAL(selectionChanged(QListViewItem *)),SLOT(slotSelectionChanged()));
	connect(ABLabel1,SIGNAL(clicked()),SLOT(slotView()));
}

GroupViewWidget::~GroupViewWidget(){
	groupManager -> startScheduling();
}

void GroupViewWidget::hide(){	delete this;}

void GroupViewWidget::slotUpdateUDG(){
	for (unsigned int i = 0; i < groupManager -> count(TYPE_UDG); i++)
		groupManager -> udg(i) -> unloadFiles();
	groupManager -> update(TYPE_UDG,getenv("HOME"));
	groupManager -> showUpdateProgress(groupType(), true);
}

void GroupViewWidget::slotSetupFileList(FileGroupBase * g){	FileListView1 -> setFileGroup(g); }

void GroupViewWidget::slotFileSelectionChanged(FileGroupBase * g){
		QString s1,s2,s3,s4,s5,s6;
		s1.setNum( g -> numMarked() );
		s2.setNum( g -> numGreen() );
		s3.setNum( g -> sizeMarked() );
		s4.setNum( g -> sizeGreen());
		TextLabel1 -> setText(i18n("Files selected:\t") + s1 + " / " + s2 + "\n"
			+ i18n("Bytes selected:\t")  + s3 + " / " + s4 );
}

void GroupViewWidget::slotHelp(){	kapp -> invokeHTMLHelp("kleandisk/udg.html","");}

void GroupViewWidget::slotSelectAll(){
	FileListView1 -> markAll();
	if (!FileListView1 -> fileGroup() -> numMarked())
		KMessageBox::information(0,i18n("No files have been selected. There are no 'green' files."));
}

void GroupViewWidget::slotDeSelectAll(){ FileListView1 -> deMarkAll(); }

void GroupViewWidget::slotView(){
	QListViewItem * i = FileListView1 -> selectedItem();
	QString file(FileListView1 -> fileName(i));
	(void) new KRun(file);
}

void GroupViewWidget::slotSelectionChanged(){
	QListViewItem * i = FileListView1 -> selectedItem();
	QString file(FileListView1 -> fileName(i));
	KURLPixmapProvider p;
	ABLabel1 -> setPixmap(p.pixmapFor(file,KIcon::SizeMedium));
}

bool GroupViewWidget::isGroupType(grouptype t){
	bool b = false;
	if (t == groupType())
		b = true;
	return b;
}

void GroupViewWidget::slotSetProperties(FileGroupBase *g){
	QString pr = "";
	pr += i18n("Name: ");
	pr += g -> name();
	pr += "\n\n";
	pr += i18n("Description: ");
	pr += g -> info(INFO_DESCRIPTION);
	MultiLineEdit1 -> setText(pr);
}

void GroupViewWidget::slotCleanup(){
	FileGroupExt * g = (FileGroupExt*)FileListView1 -> fileGroup();
	emit cleanup(g);
}

