/***************************************************************************
                          insitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 16 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "insitem.h"
#include "groupviewwidget.h"
#include <iostream.h>

INSItem::INSItem(GroupManager * g, GroupViewWidget * gv) : GroupItem(g,gv){
	setType(TYPE_INS);
	KIconLoader l;
	topItem() -> setText(0,"Installed Files");
	topItem() -> setPixmap(0,l.loadIcon("mime_empty", KIcon::Small));	
	setup();
}

INSItem::~INSItem(){
}

void INSItem::setup(){
	deleteChilderen();
	for (unsigned int i = 0; i < groupManager() -> count(TYPE_INS); i++){
		INS * ins = groupManager() -> ins(i);
		QListViewItem * item = topItem(), *parent;
		for (unsigned int j = 0; j < ins -> numParts(); j++){
			parent = item;
			item = itemHasChild(item,ins -> partOfName(j));
			if (!item){
				item = new QListViewItem(parent, ins -> partOfName(j));
				item -> setOpen(true);
				if (j == ins -> numParts() - 1){
					insToItem(ins, item);
					item -> setText(0,ins -> partOfName(j));
				}
			}
		}
	}
}

void INSItem::slotItemClicked(QListViewItem * i, const QPoint &p, int c){
	if (!groupManager() -> isInit(TYPE_INS)){
		groupManager() -> init(TYPE_INS);
		setup();
	}
	if (i == topItem())
	  i -> setOpen(!i -> isOpen());
	if ( hasAncestor(i,topItem()) & !name(i).isEmpty()){
		if (c == 0){
			emit setupFileList(groupManager() -> ins(name(i)));
			cout << name(i) <<"\n";
		}
		if ( c == 1){
			INS * ins = groupManager() -> ins(name(i));
			ins -> setMarked(!ins -> isMarked());
			if (ins -> isMarked()){
				KIconLoader icnl;
				i -> setPixmap(1,QPixmap(icnl.loadIcon("flag",KIcon::Small)));
			}
			else
				i -> setPixmap(1,QPixmap());
			insToItem(ins,i);
			i -> setText(0,ins -> partOfName(ins -> numParts() - 1));
		}
	}
}

void INSItem::slotCleanupEnded(){
	INS * i;
	i = groupManager() -> ins(name(selectedItem()));
	i -> empty();
	i -> loadFiles();
	insToItem(i,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(i);
}

void INSItem::insToItem(INS * ins, QListViewItem * i){
	groupToItem(ins,i);
	KIconLoader icnl;
	i -> setPixmap(0,icnl.loadIcon("mime_empty", KIcon::Small));
}
