/***************************************************************************
                          rpm.cpp  -  description
                             -------------------
    begin                : Fri Dec 17 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rpm.h"
#include <iostream.h>
#include <fcntl.h>

#include <rpm/rpmlib.h>
#include <rpm/rpmio.h>
#include <kmessagebox.h>

RPM::~RPM(){
}

RPM::RPM(const QString f, unsigned int s){
	cout << f << "\n";
	setSafetyLevel(s);
	setName(f);
	setType(TYPE_RPM);
	loadFiles();
}

void RPM::loadFiles(){
  unloadFiles();
	char **fileList;	
	Header h;
	int stat;
	rpmdb db;
	int count;
	QString n(name());
	dbiIndexSet matches;

  rpmReadConfigFiles("","");
	if (rpmdbOpen("", &db, O_RDONLY, 0644)) {
		KMessageBox::information(0,"ERROR");
	}
  stat = rpmdbFindByLabel(db, const_cast<char*>(n.ascii()), &matches);
	h = rpmdbGetRecord(db, matches.recs[0].recOffset);
	rpmBuildFileList(h, (const char ***) &fileList, &count);

	if(fileList != 0){
		sg = 0;
		ts = 0;
		for(int i=0; i < count; i++){
			QString s(fileList[i]);
			QFileInfo fi(s);
			if (fi.isFile()){
				addFileFast(s);
				ts += fi.size();
				if (isSafe(s))
					sg += fi.size();
			}
		}
		free(fileList);
	}
	headerFree(h);
	dbiFreeIndexRecord(matches);
	rpmdbClose(db);

}

ABProcess *  RPM::unInstall(){
	ABProcess * r = new ABProcess("rpm");
	*r << "rpm";
	*r << "-e";
	*r << name();
	return r;
}

/*bool RPM::isSafe(QString  s){
	bool b;
	QDateTime current_date_time = QDateTime::currentDateTime();
	QFileInfo fi(s);
	QDateTime dat(fi.lastRead());
	unsigned int t = dat.secsTo(current_date_time)/(86400);
	if (t < safetyLevel())
		b = false;
	else
		b = true;
	return b;
}*/

QString RPM::info(infotag i){
	QString b;
	Header h;
	int stat;
	rpmdb db;
	int_32 type, count;
	char * str;
	QString n(name());
	dbiIndexSet matches;

  rpmReadConfigFiles("","");
	if (rpmdbOpen("", &db, O_RDONLY, 0644)) {
		KMessageBox::information(0,"ERROR");
	}
  stat = rpmdbFindByLabel(db, const_cast<char*>(n.ascii()), &matches);
	h = rpmdbGetRecord(db, matches.recs[0].recOffset);
	switch (i){
		case INFO_NAME:
			headerGetEntry(h, RPMTAG_NAME, &type, (void **) &str, &count);
			break;
		case INFO_DESCRIPTION:
			headerGetEntry(h, RPMTAG_DESCRIPTION, &type, (void **) &str, &count);
			break;
	}
  b = QString(str);
	headerFree(h);
	dbiFreeIndexRecord(matches);
	rpmdbClose(db);
	return b;
}

