/***************************************************************************
                          udgtree.h  -  description
                             -------------------
    begin                : Wed Dec 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UDGTREE_H
#define UDGTREE_H

#include <grouptree.h>
#include "buttonlabelwidget.h"
#include "abprocess.h"
#include "udg.h"

/**
  *@author Arjan Buursink
  */

class UDGTree : public GroupTree  {
	Q_OBJECT
public:
	UDGTree(GroupViewWidget *);
	~UDGTree();
	void saveGroups();
private slots:
	void slotPopup(QListViewItem *, const QPoint &, int);
	void slotNewUDG();
	void slotEditUDG();
	void slotDeleteUDG();
	void slotQuickArchive();
	void slotQuickArchiveCompleted();
	void slotQuickArchiveCancelClicked(){proc -> kill();};	
	void slotCleanupEnded();
	void slotUpdateGroups();
	void slotUpdateGroup();
	void slotUpdateGroups(KProcess *, char * b, int l);
private:
	void itemClicked(QListViewItem *, const QPoint &, int);
	void updateReady();
	void update(QString dir="");
	ButtonLabelWidget * updateProgress;
	void groupToItem(FileGroupBase *, QListViewItem *);
	ButtonLabelWidget3 * progress;
	ABProcess * proc;
	void setup();
	void setupDefaultGroups();
	QString std;
};

#endif
