/***************************************************************************
                          kcontainer.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
  
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTAINER_H
#define KCONTAINER_H

#include "kobject.h"

class KContainerImpl;

/** 
 * @short Bridge class for @ref KContainerImpl 
 * @author Sergio Moretti
 * @version $Id$
 */

class KContainer : public KObject {

  friend class KObject;

public:
  KContainer() {}

  List globals() const;
  bool isEmpty() const;
  void clear();
  // items creation/deletion
  KObject itemCopy(const QDomElement &e) const;
  void itemRemove(const KObject &item);
  KObject itemFindId(int id) const;
  int itemFind(const KObject &item) const;
  KObject itemAt(int index) const;
  KObject itemFirst() const;
  KObject itemLast() const;
  KObject itemNext() const;
  KObject itemPrev() const;
  int itemCount() const;
  int itemActiveCount() const;

protected:
  KContainer(KContainerImpl * impl);
  KContainerImpl * impl() const;
  // masked methods
  KObject::toTransfer;
};

#endif // KCONTAINER_H

/* Local Variables: */
/* mode: c++ */
/* End: */
