/***************************************************************************
                          kdlgtransferstatus.cpp  -  description
                             -------------------
    begin                : Thu Sep 7 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision						 : $Revision: 1.11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qdir.h>
#include "ktmanager.h"
#include "utils.h"
#include "kmago.h"
#include "kmagodoc.h"
#include "kdlgtransferstatus.h"

KDlgTransferStatus::KDlgTransferStatus(KTransfer tr, QWidget *parent, 
				       const char *name) : 
  QWidget(parent, name,
	  WDestructiveClose
	  | WType_TopLevel | WStyle_Customize | WStyle_NormalBorder 
	  | WStyle_Title | WStyle_SysMenu | WStyle_MinMax) {
  t = tr;
  lastRunning = !t.isRunning();
  initDialog();
  init();
}

KDlgTransferStatus::~KDlgTransferStatus(){
  emit sigClose(t.id());
}

KMagoDoc * KDlgTransferStatus::getDocument() const {
  return dynamic_cast<KMagoApp*>(parent())->getDocument();
}

void KDlgTransferStatus::init() {
  setCaption("Status Transfer " + t.remote().prettyURL() + " => " 
	     + t.local().fileName());
  lblType->setText(KObject::typeStr(t.type()));
  lneURL->setText(t.remote().url());
  lneFile->setText(t.local().path());
  lnePriority->setText(QString().setNum(t.priority()));
  lblTmpfile->setText(t.getTmpFile().path());
  lblID->setAlignment(AlignRight | AlignVCenter);
  lblID->setNum((int)t.id());
  lblTEst->setAlignment(AlignRight | AlignVCenter);
  lblTStart->setAlignment(AlignRight | AlignVCenter);
  slotUpdate(t);
  connect(getDocument(), SIGNAL(sigTransferStateChange(KTransfer)), 
	  this, SLOT(slotUpdate(KTransfer)));
  connect(getDocument(), SIGNAL(sigTransferConfChange(KTransfer)), 
	  this, SLOT(slotUpdate(KTransfer)));
  connect(getDocument(), SIGNAL(sigTransferReadData(KTransfer)), 
	  this, SLOT(slotUpdate(KTransfer)));
}

void  KDlgTransferStatus::initDialog(){

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(2, Horizontal, i18n("Url & File"), 
				  this, "GB1");
  l->addWidget(gbox);

  new QLabel(i18n("Url:"), gbox);
  lneURL = new QLineEdit(gbox, "LneURL");
  QToolTip::add(lneURL,i18n("Url to download"));

  new QLabel(i18n("File:"), gbox);
  lneFile = new QLineEdit(gbox, "LneFile");
  QToolTip::add(lneFile,i18n("File to write"));
  
  new QLabel(i18n("Tmp File:"), gbox);
  lblTmpfile = new QLabel(gbox, "LblTmpFile");

  new QLabel(i18n("Type:"), gbox);
  lblType = new QLabel(gbox, "LblType");

  gbox = new QGroupBox(4, Horizontal, i18n("Running"), this, "GB2");
  l->addWidget(gbox);

  new QLabel(i18n("Start:"), gbox);
  lblTStart = new QLabel(gbox, "LblTStart");

  new QLabel(i18n("Est. Time"), gbox);
  lblTEst = new QLabel(gbox, "LblTEst");

  new QLabel(i18n("Band:"), gbox);
  lblBand = new QLabel(gbox, "LblBand");

  new QLabel(i18n("Medium B.:"), gbox);
  lblMBand = new QLabel(gbox, "LblMBand");

  new QLabel(i18n("Try n.:"), gbox);
  lblRetry = new QLabel(gbox, "LblRetry");

  gbox = new QGroupBox(4, Horizontal, i18n("State"), this, "GB3");
  l->addWidget(gbox);
  /*
  QWidget *wdg = new QWidget(gbox);
  QGridLayout *grid = new QGridLayout(wdg, 4, 4, 0, 8);
  grid->setColStretch(0, 1);
  grid->setColStretch(1, 10);
  grid->setColStretch(2, 1);
  grid->setColStretch(3, 11);
  */
  QLabel *lbl = new QLabel(i18n("ID:"), gbox);
  //grid->addWidget(lbl, 0, 0);
  lblID = new QLabel(gbox, "LblID");
  //grid->addWidget(lblID, 0, 1);

  lbl = new QLabel(i18n("Priority"), gbox);
  //grid->addWidget(lbl, 0, 2);
  lnePriority= new QLineEdit(gbox, "LnePriority");
  lnePriority->setFixedWidth(lnePriority->fontMetrics().width("XXXXX"));
  //grid->addWidget(lnePriority, 0, 3);

  lbl = new QLabel(i18n("Status:"), gbox);
  //grid->addWidget(lbl, 1, 0);
  lblStatus = new QLabel(gbox, "lblStatus");
  //grid->addMultiCellWidget(lblStatus, 1, 1, 1, 3);
  gbox->addSpace(0);
  gbox->addSpace(0);

  lbl = new QLabel(i18n("Partial:"), gbox);
  //grid->addWidget(lbl, 2, 0);
  lblPartial = new QLabel(gbox, "LblPartial");
  //grid->addWidget(lblPartial, 2, 1);

  lbl = new QLabel(i18n("Length:"), gbox);
  //grid->addWidget(lbl, 2, 2);
  lblLen = new QLabel(gbox, "LblLen");
  //grid->addWidget(lblLen, 2, 3);

  lbl = new QLabel(i18n("Resumable:"), gbox);
  //grid->addWidget(lbl, 3, 0);
  lblResumable = new QLabel(gbox, "LblResumable");
  //grid->addWidget(lblResumable, 3, 1);

  lbl = new QLabel(i18n("Resumed:"), gbox);
  //grid->addWidget(lbl, 3, 2);
  lneResumed = new QLineEdit(gbox, "LneResumed");
  lneResumed->setFixedWidth(lneResumed->fontMetrics().width("XXXXX"));
  //grid->addWidget(lneResumed, 3, 3);

  QHBoxLayout *btnBox = new QHBoxLayout(l);
  btnBox->addStretch(1);

  btnOK = new QPushButton(i18n("OK"), this, "BtnOK");
  btnOK->setDefault(true);
  btnBox->addWidget(btnOK);
  connect(btnOK, SIGNAL(clicked()), this, SLOT(accept()));

  btnApply = new QPushButton(i18n("Apply"), this, "BtnApply");
  btnBox->addWidget(btnApply);
  connect(btnApply, SIGNAL(clicked()), this, SLOT(apply()));

  btnCancel = new QPushButton(i18n("Cancel"), this, "BtnCancel");
  btnBox->addWidget(btnCancel);
  connect(btnCancel, SIGNAL(clicked()), this, SLOT(close()));
}

void KDlgTransferStatus::slotUpdate(KTransfer tr) {
  if (tr != t)
    return;
  QString s;
  lblStatus->setText(t.statusStr());
  lblLen->setAlignment(AlignRight | AlignVCenter);
  lblLen->setText(unit(t.len()) + "B");
  lblResumable->setText(t.rsmStatusStr());
  lblBand->setAlignment(AlignRight | AlignVCenter);	
  lblBand->setText(unit(t.bandwidth()) + "B/s");
  lblMBand->setAlignment(AlignRight | AlignVCenter);
  lblMBand->setText(unit(t.mediumBandwidth()) + "B/s");
  lblPartial->setAlignment(AlignRight | AlignVCenter);
  lblPartial->setText(unit(t.partial()) + "B");
  lneResumed->setText(s.setNum(t.resumed()));
  lblRetry->setAlignment(AlignRight | AlignVCenter);
  lblRetry->setNum(t.retry());
  if(t.isRunning()) {
    lblTStart->setText(t.startTime().toString());
    lblTEst->setText(t.estTime().toString());
  } else {
    lblTStart->setText("");
    lblTEst->setText("");
  }
  if (t.isRunning() != lastRunning) {
    bool on = !t.isRunning();
    lneFile->setEnabled(on);
    lneURL->setEnabled(on);
    lneResumed->setEnabled(on);
    lnePriority->setEnabled(on);
    btnOK->setEnabled(on);
    btnApply->setEnabled(on);
    lastRunning = t.isRunning();
  }
}

bool KDlgTransferStatus::isAcceptable() const {
  bool check;
  QString(lneResumed->text()).toInt(&check);
  if (!check)
    return false;
  QString(lnePriority->text()).toInt(&check);
  if (!check)
    return false;
  QString file = lneFile->text();
  if (file.isEmpty() || !QFileInfo(file).dir().exists())
    return false;
  QString url = lneURL->text();
  if (url.isEmpty() || KURL(url).isMalformed())
    return false;
  return true;
}

void KDlgTransferStatus::apply() {
  if (!isAcceptable())
    return;
  t.setPriority(QString(lnePriority->text()).toInt());
  t.setLocal(lneFile->text());
  t.setRemote(lneURL->text());
  t.setResumed(QString(lneResumed->text()).toInt());
  t.setModified(MOD_STATE, PRP_ALL);
  lblTmpfile->setText(t.getTmpFile().path());
  //FIMXE se cambio file, url, non aggiorna status bar,<=> non cambia stato manager
}

void KDlgTransferStatus::accept() {
  if (!isAcceptable())
    return;
  apply();
  close();
}

/**  */
void KDlgTransferStatus::close(){
  QWidget::close();
  //delete this;
}

#include "kdlgtransferstatus.moc"
