/***************************************************************************
                          kmagodoc.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGODOC_H
#define KMAGODOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <kbugreport.h>

// application specific includes
#include "kmmanager.h"
#include "ktmanager.h"
#include "ktransfer.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


class KMagoBugReport : public KBugReport {
  Q_OBJECT
public:
  KMagoBugReport(QWidget * parent = 0L, bool modal=true, 
		 const KAboutData *aboutData = 0L);
  void appendLine(const QString &line);
};


class KMagoApp;
// forward declaration of the KMago classes
//class KMagoView;

/**	KMagoDoc provides a document object for a document-view model.
  *
  * The KMagoDoc class provides a document object that can be used in conjunction with the classes KMagoApp and KMagoView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the KMagoApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KMagoView objects. Also, KMagoDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class KMagoDoc : public QObject {

  Q_OBJECT

  class NotifyChange : public KNotifyChange {
  public:
    NotifyChange(KMagoDoc *doc) : _doc(doc) {}
    virtual ~NotifyChange() {}
    virtual void operator()(const KObject source, ModType type) const;
  private:
    KMagoDoc *_doc;
  };

  friend class NotifyChange;
  
public:
  /** Constructor for the fileclass of the application */
  KMagoDoc(QWidget *parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KMagoDoc();
	  
  /** open a new document from a temporary file */
  bool openNew();
  /** loads the document by filename and emits the updateViews() signal */
  bool open(const QString &filename);
  /** save document, if filename != "" then save in the current file,
   * and then copy the data to the new file
   */
  bool saveAs(const QString &filename);
  /** close the document */
  void close();
  bool isClosed() const { return _manager.isNull(); }
  KMManager manager() const { return _manager; }
  QString title() const { return _title; }
  int isDuplicate(const KURL &rmt, const KURL &lcl);

protected: // Protected methods
  /** get the main view */
  KMagoApp * mainView() const;
  /** connect to main */
  void connectToMain();
  /** callback to emit signals */
  void notifyChange(const KObject source, ModType type);
  void setTitle(const QString &title) { _title = title; }

public slots:
  /** slot to connect to a timer signal to update state saved */
  void slotUpdate();

signals:
  void sigMManagerChange();
  void sigTManagerAdd(KTManager);
  void sigTManagerRemove(KTManager);
  void sigTManagerStateChange(KTManager);
  void sigTManagerConfChange(KTManager);
  void sigTransferAdd(KTransfer);
  void sigTransferRemove(KTransfer);
  void sigTransferStateChange(KTransfer);
  void sigTransferConfChange(KTransfer);
  void sigTransferReadData(KTransfer);

private:
  KMManager _manager;
  QString _title;
};

#endif // KMAGODOC_H

/* Local Variables: */
/* mode: c++ */
/* End: */
