/***************************************************************************
                          ktmanager.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktransferimpl.h"
#include "ktmanagerimpl.h"
#include "kmmanager.h"
#include "ktransfer.h"
#include "ktmanager.h"


KTransfer KTManager::findGlobal(int type) const {
  return KTransfer(dynamic_cast<KTransferImpl*>(impl()->findGlobal(type)));
}

QString KTManager::title() const {
  return impl()->title();
}

void KTManager::killAll() {
  impl()->killAll();
}

int KTManager::bandwidth() const {
  return impl()->bandwidth();
}

int KTManager::mediumBandwidth() const {
  return impl()->mediumBandwidth();
}

KTransfer KTManager::itemNew(int type, const KURL &rmt, const KURL &lcl) {
  return KTransfer(impl()->itemNew(type, rmt, lcl));
}
 
bool KTManager::getAutoDownload() const {
  return impl()->getAutoDownload();
}

void KTManager::setAutoDownload(bool m) {
  impl()->setAutoDownload(m);
}

bool KTManager::getAutoRemove() const {
  return impl()->getAutoRemove();
}

void KTManager::setAutoRemove(bool r) {
  impl()->setAutoRemove(r);
}

int KTManager::getMaxConnection() const {
  return impl()->getMaxConnection();
}

void KTManager::setMaxConnection(int c) {
  impl()->setMaxConnection(c);
}

int KTManager::getMaxBandwidth() const {
  return impl()->getMaxBandwidth();
}

void KTManager::setMaxBandwidth(int b) {
  impl()->setMaxBandwidth(b);
}

const QDir & KTManager::getDownloadDir() const {
  return impl()->getDownloadDir();
}

void KTManager::setDownloadDir(const QString &d) {
  impl()->setDownloadDir(d);
}

const QDir & KTManager::getWorkingDir() const {
  return impl()->getWorkingDir();
}

void KTManager::setWorkingDir(const QString &d) {
  impl()->setWorkingDir(d);
}

QString KTManager::getLogFile() const {
  return impl()->getLogFile();
}

void KTManager::setLogFile(const QString &d) {
  impl()->setLogFile(d);
}

int KTManager::getPriority() const {
  return impl()->getPriority();
}

void KTManager::setPriority(int p) {
  impl()->setPriority(p);
}

int KTManager::getDefaultType() const {
  return impl()->getDefaultType();
}

void KTManager::setDefaultType(int t) {
  impl()->setDefaultType(t);
}

const char * KTManager::docId() { 
  return KTManagerImpl::DOCID; 
}

const char * KTManager::docType() {
  return KTManagerImpl::DOCTYPE;
}

const char * KTManager::mimeType(int i) {
  return KTManagerImpl::MIMETYPE[i];
}

KTManager::KTManager(KTManagerImpl *impl) : KContainer(impl) {
}

KTManagerImpl * KTManager::impl() const {
  return dynamic_cast<KTManagerImpl*>(KContainer::impl());
}
