/***************************************************************************
                          ktransfer.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFER_H
#define KTRANSFER_H

#include <qdatetime.h>
#include <qstring.h>
#include <kprocess.h>
#include <kurl.h>
#include <qfile.h>
#include "kobject.h"

class KTManager;
class KTransferImpl;

/**Interface for abstract type KTransfer
 *@author Sergio Moretti
 */

class KTransfer : public KObject {
  
  friend class KObject;
  friend class KTManager;

public:
  KTransfer() {}

  /** document name */
  static const char * docId();
  /** dom document type */
  static const char * docType();
  /** mime type */
  static const char * mimeType(int i);

  // read-only state
  int len() const;
  int partial() const;
  int retry() const;
  /** get the istantaneaous bandwidth */
  int bandwidth() const;
  /** get the medium bandwidth */
  int mediumBandwidth() const;
  /** get start time */
  QTime startTime() const;
  /** get the status of the transfer*/
  Status status() const;
  CommandStatus cmdStatus() const;
  ResumeStatus rsmStatus() const;
  /* get status converted in string form */
  QString statusStr() const;
  /** get status converted in string form */
  QString filStatusStr() const;
  /** get status converted in string form */
  QString cmdStatusStr() const;
  /** get the resumable state string: Yes, No, ??? */
  QString rsmStatusStr() const;
  /** get the fatal error log */
  QString fatalErrorLog() const;

  /** get the local file */
  const KURL & local() const;
  /** set local file */
  void setLocal(const KURL &lcl);
  void setLocal(const QString &lcl);
  /** get the url */
  const KURL & remote() const;
  /** set url */
  void setRemote(const KURL &rmt);
  int resumed() const;
  void setResumed(int r);
  /** get priority */
  int priority() const;
  /** set priority */
  void setPriority(int p);

  // OPERATIONS on transfer

  /** check for resume capabilities */
  void checkResumeCapability();
  /** check if protocol is supported */
  bool isProtocolSupported(const QString &proto) const;
  /** true if transfer is complete */
  bool isComplete() const;
  /** check if the process can be started */
  bool isRunnable(bool automatic);
  /** check for transfer resume capability */
  bool isResumable() const;
  /** check if process is running */
  bool isRunning() const;
  /** download estimated time */
  QTime estTime() const;
  /** get the temporary file */
  KURL getTmpFile() const;
  /** get the temporary file */
  KURL getTempFile(const KURL &rmt, const KURL &lcl) const;
  /** start the command process */
  void start();
  /** kill the command process */
  void kill();

  // CONFIG
  
  bool getCheckResume() const;
  void setCheckResume(bool c);
  int getMaxResume() const;
  void setMaxResume(int r);
  bool getAutoResume() const;
  void setAutoResume(bool m);
  int getWaitResume() const;
  void setWaitResume(int w);
  int getMaxRetry() const;
  void setMaxRetry(int m);
  int getWaitRetry() const;
  void setWaitRetry(int w);
  int getBandSampleTime() const;
  void setBandSampleTime(int t);
  int getReadNotifyTime() const;
  void setReadNotifyTime(int t);
  int getPriorityPolicy() const;
  void setPriorityPolicy(int p);
  bool getLogProcess() const;
  void setLogProcess(bool l);

protected:
  KTransfer(KTransferImpl * impl);
  KTransferImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
