/***************************************************************************
                          ktransferdrag.cpp  -  description
                             -------------------
    begin                : Sat Oct 21 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qtextstream.h>
#include "ktransferdrag.h"


KTransferDrag::KTransferDrag(KTransfer trn, QWidget *dragSource, 
			     const char *name) 
  : QDragObject(dragSource, name), t(trn) {
}

const char* KTransferDrag::format(int i) const {
  kdDebug(D_RUN) << t.name() << ": drag format " << i << endl;
  switch (i) {
  case 0:
    return KTransfer::mimeType(i);
  case 1:
    return "text/uri-list";
  case 2:
    return "text/plain";
  }
  return 0;
}
  
QByteArray KTransferDrag::encodedData(const char* mimetype) const {
  QByteArray data;
  QTextStream s(data, IO_WriteOnly);
  if (strcmp(mimetype, KTransfer::mimeType(0)) == 0) {
    s << KTransfer::docType() << endl;
    t.dom().save(s ,0);
  } else if (strcmp(mimetype, "text/uri-list") == 0 
	     || strcmp(mimetype, "text/plain") == 0) {
    s << t.remote().url();
  } else {
    kdFatal(D_RUN) << t.name() << ": DRAG UNKNOWN MIME" << endl;
  }
  return data;
}

bool KTransferDrag::canDecode(const QMimeSource *e) {
  return (e->provides(KTransfer::mimeType(0)));
}

bool KTransferDrag::decode(const QMimeSource *e, QDomDocument &dom) {
  kdDebug() << "KTransferDrag: drag decode " << endl;
  QByteArray data;
  for (int i = 0; i < 1; i++)
    if (e->provides(KTransfer::mimeType(i))) {
      kdDebug(D_RUN) << "KTransferDrag: decode " << KTransfer::mimeType(i) << endl;
      QByteArray data = e->encodedData(KTransfer::mimeType(i));
      return dom.setContent(data);
    }
  return false;
}

