/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 12:21:31 CEST 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kmago.h"

static const char *description = I18N_NOOP("The KDE MAnager of Get Operation - A download manager.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	

static KCmdLineOptions options[] = {
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[]) {
  
  KAboutData aboutData( "kmago", I18N_NOOP("KMago"),
			VERSION, description, KAboutData::License_GPL,
			"(c) 2000, Sergio Moretti",
			0,
			"http://kmago.sourceforge.net",
			"sermore@users.sourceforge.net");
  aboutData.addAuthor("Sergio Moretti",0, "sermore@libero.it");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
 
  if (app.isRestored()) {
    RESTORE(KMagoApp);
  } else {
    KMagoApp *kmago = new KMagoApp();
    kmago->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    
    if (args->count())
      kmago->openDocument(args->arg(0));
    else if (kmago->getLoadLastDoc())
      kmago->openLastUsedDocument();
    else
      kmago->newDocument();
    args->clear();
  }

  return app.exec();
}  
