/*
    KMLOFax
    
    A utility to process facsimiles received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2001 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef MLOFILE_H
#define MLOFILE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qfile.h>


#define PAGE_LEN_A4 0	// A4, 297 mm
#define PAGE_LEN_B4 1	// B4, 364 mm
#define PAGE_LEN_UL 2	// unlimited


#define MAX_IMG_BUFF  304
#define MAX_RLE_BUFF 2433
#define MAX_HUF_BUFF 2048



typedef struct {
	uchar code;
	uchar width;
	short len;
} hcode_t;



typedef struct {
	ushort params;
	int lpi;
	int bit_rate;
	int width;
	int length;
	bool comp_2d;
} page_info_t;





class MLOFile : public QFile
{
public:
	MLOFile(const char *name);
	MLOFile();
	~MLOFile();

	void setName(const char *name);
	
	bool open();
	virtual void close();

	int readLine(char *line, uint maxlen);

	void readRleLine(short line[]);
	void readImgLine(uchar line[], bool lsb_first);
	int readHuffLine(uchar line[]);

	const char *sender();
	int pages();
	bool gotoPage(int page);
	bool readPageInfo(int page, page_info_t *info);
	int pageHeight(int page);
	int pageUsedHeight(int page);

private:
	void init();
	void init_data();

	int getDataCh();
	bool getDataBits(uchar width);
	void cutDataBits(uchar width);
	bool codeMatches(const uchar code, const uchar width);
	short findMatch(const hcode_t table[]);
	bool skipEol();
	void fillDataLine(uchar *line, short pos, short len, bool lsb_first);
	short getRunLength(const hcode_t table[], uchar max_width);

	bool decode1DDataLine(short run_lengths[], bool probeonly);
	bool decode2DDataLine(short run_lengths[], bool probeonly);
	void decodeDataLine(short run_length[], bool probeonly);

	int storeDataCode(uchar dest[], int pos, const hcode_t& code);
	int encodeDataLine(uchar dest[]);

	bool data_mode;

	ulong data_buff;
	uchar data_width;

	int fax_page;
	int fax_pages;

	char fax_sender[21];

	ushort page_params;
	int page_width;
	int page_height;
	int page_used_height;
	int page_length;
	int page_lpi;
	int page_bit_rate;
	bool page_2d;

	short refline[MAX_RLE_BUFF];
};


#endif // MLOFILE_H
