/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qstring.h>


#define KMLOVOICE_MESSAGEDIR	"messagesrc"
#define KMLOVOICE_ALIASLIST		"aliasesrc"

#define ID_PREF_GROUP_GENERAL	"General"
#define ID_PREF_GEN_TOOLTIPS	"ToolTips"
#define PREF_GEN_TOOLTIPS			true
#define ID_PREF_GEN_LOADNEW		"DownloadNew"
#define PREF_GEN_LOADNEW			false
#define ID_PREF_GEN_DELETEMSG	"DeleteMessage"
#define PREF_GEN_DELETEMSG		true

#define ID_PREF_GROUP_MODEM		"Modem"
#define ID_PREF_MOD_DEVICE		"Device"
#define PREF_MOD_DEVICE   		"/dev/modem"
#define ID_PREF_MOD_SPEED			"Speed"
#define PREF_MOD_SPEED    		1		// == 38400 Bps

#define ID_PREF_GROUP_PLAY		"PlayBack"
#define ID_PREF_PLAY_DEVICE		"DspDevice"
#define PREF_PLAY_DEVICE			"/dev/dsp"
#define ID_PREF_PLAY_MIXER		"MixerDevice"
#define PREF_PLAY_MIXER				"/dev/mixer"

#define ID_PREF_GROUP_MAIL		"Mail"
#define ID_PREF_MAIL_SERVER		"Server"
#define PREF_MAIL_SERVER			"localhost"
#define ID_PREF_MAIL_PORT			"Port"
#define PREF_MAIL_PORT				25
#define ID_PREF_MAIL_NAME			"Name"
#define PREF_MAIL_NAME				""
#define ID_PREF_MAIL_ORG			"Organization"
#define PREF_MAIL_ORG					""
#define ID_PREF_MAIL_EMAIL		"Email"
#define PREF_MAIL_EMAIL				""
#define ID_PREF_MAIL_REPLY		"Reply"
#define PREF_MAIL_REPLY				""


#define ID_FILE_DOWNLOAD           10010
#define ID_FILE_PLAYBACK           10020
#define ID_FILE_EXPORT             10030
#define ID_FILE_MAIL               10040
#define ID_FILE_DELETE             10050
#define ID_FILE_CALLER_ALIAS       10060
#define ID_FILE_PURGE_DIRECTORY    10070
#define ID_FILE_QUIT               10080

#define ID_SETTINGS_TOOLBAR        11010
#define ID_SETTINGS_STATUSBAR      11020
#define ID_SETTINGS_SAVEOPTIONS    11030
#define ID_SETTINGS_CALLER_ALIASES 11040
#define ID_SETTINGS_CONFIGURE      11050

#define ID_HELP_CONTENTS           1002
#define ID_HELP_ABOUT              1003

#define ID_STATUS_MSG              1001


#define VOI_UNKNOWN   0
#define VOI_ADPCM2_7  1
#define VOI_ADPCM2_8  2
#define VOI_ADPCM4_7  3
#define VOI_ADPCM4_8  4
#define VOI_PCM8L_7   5
#define VOI_PCM8L_8   6



QString expandPath(const QString& fname);

QString mloDateStr(const char *name);

void mloDateSplit(const char *name, int *year, int *month, int *day, int *hour, int *minute, int *second);

#endif // GLOBAL_H
