/***************************************************************************
                          attributedialog.h  -  description                              
                             -------------------                                         
    begin                : Sat Sep 11 1999                                           
    copyright            : (C) 1999 by Henrik Stormer                         
    email                : stormer@ifi.unizh.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ATTRIBUTEDIALOG_H
#define ATTRIBUTEDIALOG_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qlabel.h>
//Generated area. DO NOT EDIT!!!(end)

#include "basedialog.h"

#define SET 1
#define UNSET 2
#define NOSTATE 3
#define UNDEF 4


class MyCheckBox : public QCheckBox
{
 public:
  MyCheckBox(QWidget* parent, const char* name) : QCheckBox(parent, name) {setTristate(true);setState(QButton::NoChange);}
  void setState(char State)
  {
    if (State == SET) setOn(true);
    if (State == UNSET) setOn(false);
    if (State == NOSTATE) setNoChange();
  }
  char getState()
  {
    if (state() == QButton::On) return SET;
    if (state() == QButton::Off) return UNSET;
    if (state() == QButton::NoChange) return NOSTATE;
    return UNDEF;
  }
};

/**
  *@author Henrik Stormer
  */
class QCheckBox;

class AttributeDialog : public BaseDialog  {
   Q_OBJECT
public: 
	AttributeDialog(QWidget *parent=0, const char *name=0);
	~AttributeDialog();

public slots:

  void setReadUser(char Attrib) {_ReadUser->setState(Attrib);}
  void setWriteUser(char Attrib) {_WriteUser->setState(Attrib);}
  void setExecuteUser(char Attrib) {_ExecuteUser->setState(Attrib);}

  void setReadGroup(char Attrib) {_ReadGroup->setState(Attrib);}
  void setWriteGroup(char Attrib) {_WriteGroup->setState(Attrib);}
  void setExecuteGroup(char Attrib) {_ExecuteGroup->setState(Attrib);}

  void setReadOther(char Attrib) {_ReadOther->setState(Attrib);}
  void setWriteOther(char Attrib) {_WriteOther->setState(Attrib);}
  void setExecuteOther(char Attrib) {_ExecuteOther->setState(Attrib);}

  void setOwner(QString Owner, bool Enabled);
  void setGroup(QString Group, bool Enabled);

  QString getOwner() {return _Owner->text();}
  QString getGroup() {return _Group->text();}

  char getReadUser() {return _ReadUser->getState();}
  char getWriteUser() {return _WriteUser->getState();}
  char getExecuteUser() {return _ExecuteUser->getState();}

  char getReadGroup() {return _ReadGroup->getState();}
  char getWriteGroup() {return _WriteGroup->getState();}
  char getExecuteGroup() {return _ExecuteGroup->getState();}

  char getReadOther() {return _ReadOther->getState();}
  char getWriteOther() {return _WriteOther->getState();}
  char getExecuteOther() {return _ExecuteOther->getState();}

protected:
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QPushButton *_OK;
	QPushButton *_Cancel;
	QLineEdit *_Owner;
	QLineEdit *_Group;
  QGroupBox* QGroupBox_1, *QGroupBox_2;
  QLabel* QLabel_1, *QLabel_2;
	//Generated area. DO NOT EDIT!!!(end)
 	MyCheckBox *_ReadUser;
 	MyCheckBox *_WriteUser;
 	MyCheckBox *_ExecuteUser;
 	MyCheckBox *_ReadGroup;
 	MyCheckBox *_WriteGroup;
 	MyCheckBox *_ExecuteGroup;
 	MyCheckBox *_ReadOther;
 	MyCheckBox *_WriteOther;
 	MyCheckBox *_ExecuteOther;

private:
};

#endif















