/***************************************************************************
                          kncview.h  -  description
                             -------------------
    begin                : Tue Aug 29 14:51:43 CEST 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNCVIEW_H
#define KNCVIEW_H

// include files for Qt
#include <qwidget.h>
#include <qlistview.h>
#include <qcolor.h>

#include <kfileitem.h>
#include <kurl.h>
#include <kio/jobclasses.h>

class KNCDirLister;
class KNCListViewItem;
class KFileItem;
class DirSizeDialog;

class KNCListView : public QListView
{
  Q_OBJECT

   friend KNCListViewItem;

  public:

    KNCListView(QWidget *parent = 0, const char *name=0);
    ~KNCListView();
    void openURL(const KURL& URL, const QString& DirName = NULL);

    void setShowHiddenFiles (bool Show) {_bShowHiddenFiles = Show; slotRefresh();}
    bool getShowHiddenFiles () {return _bShowHiddenFiles;}

    KNCListViewItem* findItem  (KFileItem* f);
    KNCListViewItem* findItem  (QString Name);

    void   setFocusColor(QColor& FocusColor) {_FocusColor = FocusColor;}
    void   setFocusCursorColor(QColor& FocusCursorColor) {_FocusCursorColor = FocusCursorColor;}

    QColor& getFocusColor() {return _FocusColor;}
    QColor& getFocusCursorColor() {return _FocusCursorColor;}

    KURL&      getURL()          {return _Dir;}
    KURL::List getSelectedURLs();
    QList<KFileItem>       getSelectedItems();
    QList<KNCListViewItem> getSelectedViewItems();


    virtual void setSelected ( QListViewItem * item, bool selected );
    bool isSelection() {return ((_NumSelectedFiles != 0) || (_NumSelectedDirs != 0));}
    long getNumSelectedFiles() {return _NumSelectedFiles;}
    long getNumSelectedDirs() {return _NumSelectedDirs;}
    long getSelectedSize() {return _SelectedSize;}
    bool select(QRegExp RegExp, bool Selection);


    void saveSettings(KConfig*, const QString&);
    void readSettings(KConfig*, const QString&);

 protected:
  signals:
   void focusIn();
   void focusOut();
   void directoryChanged (const KURL&);
   void executeFile (const KURL&);
   void cursorChanged();
   void selectChanged();

 protected:

   void makeItemVisible(KNCListViewItem* Item);
   bool matchItem(KNCListViewItem* Item, QString SubString);

   KNCListViewItem* findSubStringItem(bool ascending, QString SubString);
   virtual void focusInEvent( QFocusEvent * e ) {emit focusIn();QListView::focusInEvent(e);}
   virtual void focusOutEvent( QFocusEvent * e ) {emit focusOut();QListView::focusOutEvent(e);}
   virtual void keyPressEvent ( QKeyEvent * e);
   virtual void contentsMousePressEvent(QMouseEvent*e);
   virtual void contentsMouseReleaseEvent(QMouseEvent*e);
   virtual void contentsMouseMoveEvent(QMouseEvent*);
   virtual void viewportDragEnterEvent(QDragEnterEvent*);
   virtual void viewportDragMoveEvent(QDragMoveEvent*);
   virtual void viewportDragLeaveEvent(QDragLeaveEvent*);
   virtual void viewportDropEvent(QDropEvent*);

   void startDrag();

  public slots:

   void slotEnter();
   void slotRefresh();
   void slotUp();
   void slotDown();
   void slotLeft();
   void slotRight();
   void slotPageUp();
   void slotPageDown();
   void slotScrollBegin();
   void slotScrollEnd();
   void slotInvertSelection();
   void slotInvertSelectionAndCalculate();
   void slotDirectoryUp();
   void slotResetSubString();

   void slotNewItems(const KFileItemList& FileList);
   void slotDeleteItem(KFileItem* FileItem);
   void slotRefreshItems(const KFileItemList& FileList);
   void slotResult(KIO::Job*);

   void slotDirSizeResult(KIO::Job* Job);
   void slotCalculateDirSize(KNCListViewItem* Item);
   void slotCalculateDirSize();
   void slotCancelCalculateDirSize();

  private:
    bool _bShowHiddenFiles, _BeginDrag;
    int  _ncName, _ncSize, _ncAttrib, _ncOwner, _ncGroup, _nclMod, _nclAccess, _nclRead;
    KURL          _Dir, _OldDir;
    QString       _DirName;
    bool          _KeyPressed, _TryOpen;
    KNCDirLister* _DirLister;

    QString       _SubString;
    QColor        _FocusColor, _FocusCursorColor;
    //ugly workaround, cause QListView has no way to read these variables
    int                               _SortColumn;
    bool                              _SortAscending;
    long                              _NumSelectedFiles, _NumSelectedDirs, _SelectedSize;

    QMap<KIO::Job*, KNCListViewItem*> _DirSizeJobMapping;

    KNCListViewItem*   _DragOverItem;
    bool               _DragOverItemSelected;

    DirSizeDialog*     _DirSizeDialog;
};

#endif // KNCVIEW_H
