// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: main.cpp,v 0.9 2001/01/13 21:47:27 mj Exp $
 *
 * kwatch main()
 *
 *****************************************************************************
 * Copyright (C) 2000
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "kwatch.h"



static const char *description = I18N_NOOP("KDE Log File Viewer");
static const char *version = "1.9.3";



int main(int argc, char **argv)
{
    KAboutData about("kwatch",
		     I18N_NOOP("kwatch"),
		     version, description,
		     KAboutData::License_GPL, "(C) 2000 Martin Junius");
    about.addAuthor("Martin Junius", 0, "mj@m-j-s.net");
    KCmdLineArgs::init(argc, argv, &about);
    KApplication app;

    // see if we are starting with session management
    if (app.isRestored())
        RESTORE(kwatch)
    else
    {
        // no session.. just start up normally
        new kwatch;
    }

    return app.exec();
}
