/**
 * entries.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_ENTRIES_H
#define KONFIG_ENTRIES_H

#include "entrytoken.h"

namespace KCfgCreator
{

   class StringEntry : public EntryToken
   {
    public:
        StringEntry( GroupToken* parent, const QString& key,
                     const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& value );

        QString typeName() const { return "String"; }
        Type    type() const { return String; }
    private:
        QString m_value;
    };

    class StringListEntry : public EntryToken
    {
    public:
        StringListEntry( GroupToken* parent, const QString& key,
                         const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& value );

        QString typeName() const { return "StringList"; }
        Type    type() const     { return StringList;   }
    private:
        QStringList m_value;
    };

    class FontEntry : public EntryToken
    {
    public:
        FontEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Font"; }
        Type    type() const { return Font; }
    private:
        QFont m_value;
    };

    class RectEntry : public EntryToken
    {
    public:
        RectEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Rect"; }
        Type    type() const { return Rect; }
    private:
        QRect m_value;
    };

    class SizeEntry : public EntryToken
    {
    public:
        SizeEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Size"; }
        Type    type() const { return Size; }
    private:
        QSize m_value;
    };

    class PointEntry : public EntryToken
    {
    public:
        PointEntry( GroupToken* parent, const QString& key,
                    const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Point"; }
        Type    type() const { return Point; }
    private:
        QPoint m_value;
    };

    class ColorEntry : public EntryToken
    {
    public:
        ColorEntry( GroupToken* parent, const QString& key,
                    const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Color"; }
        Type    type() const { return Color; }
    private:
        QColor m_value;
    };

    class IntEntry : public EntryToken
    {
    public:
        IntEntry( GroupToken* parent, const QString& key,
                  const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Int"; }
        Type    type() const { return Int; }
    private:
        int m_value;
    };

    class UIntEntry : public EntryToken
    {
    public:
        UIntEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "UInt"; }
        Type    type() const { return UInt; }
    private:
        uint m_value;
    };

    class BoolEntry : public EntryToken
    {
    public:
        BoolEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Bool"; }
        Type    type() const { return Bool; }
    private:
        bool m_value;
    };

    class DoubleEntry : public EntryToken
    {
    public:
        DoubleEntry( GroupToken* parent, const QString& key,
                     const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Double"; }
        Type    type() const { return Double; }
    private:
        double m_value;
    };

    class DateTimeEntry : public EntryToken
    {
    public:
        DateTimeEntry( GroupToken* parent, const QString& key,
                       const QString& name = QString::null, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "DateTime"; }
        Type    type() const { return DateTime; }
    private:
        QDateTime m_value;
    };

    class Int64Entry : public EntryToken
    {
    public:
        Int64Entry( GroupToken* parent, const QString& key,
                    const QString& name = QString::null, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Int64"; }
        Type    type() const { return Int64; }
    private:
        Q_LLONG m_value;
    };

    class UInt64Entry : public EntryToken
    {
    public:
        UInt64Entry( GroupToken* parent, const QString& key,
                     const QString& name = QString::null, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "UInt64"; }
        Type    type() const { return UInt64; }
    private:
        Q_ULLONG m_value;
    };

    class IntListEntry : public EntryToken
    {
    public:
        IntListEntry( GroupToken* parent, const QString& key,
                      const QString& name = QString::null, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant&  );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "IntList"; }
        Type    type() const { return IntList; }
    private:
        QValueList<int> m_value;
    };

    class EnumEntry : public EntryToken
    {
    public:
        // XXX : this is wrong
        EnumEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& );

        QString  valueAsString() const;
        void setValueFromString( const QString& );

        QString typeName() const { return "Enum"; }
        Type    type() const { return Enum; }
    private:
        QValueList<int> m_value;
    };

    class PathEntry : public EntryToken
    {
    public:
        PathEntry( GroupToken* parent, const QString& key,
                   const QString& name = QString::null, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Path"; }
        Type    type() const { return Path; }
    private:
        KURL m_value;
    };

}

#endif
