/**
 * manager.h
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCFGCREATOR_MANAGER_H
#define KCFGCREATOR_MANAGER_H

#include <qobject.h>

class QListViewItem;
class QPoint;
class KListView;

namespace KCfgCreator
{
    class EditorWidget;
    class MainWidget;
    class GroupItem;
    class EntryItem;

    class Manager : public QObject
    {
        Q_OBJECT
    public:
        Manager( MainWidget* parent );

    public slots:
        void renameConfig();
        void addGroup();
        void addEntry();

        void removeGroup();
        void removeEntry();

    protected slots:
        void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
        void slotSelectionChanged( QListViewItem* );

        void slotNameChanged( const QString& );
        void slotTypeChanged( const QString& );
        void slotHiddenToggled( bool );
        void slotLabelChanged( const QString& );
        void slotWhatsThisChanged();
    protected:
        void initConnections();

        GroupItem* findGroup( const QString& name );
        EntryItem* findEntry( GroupItem* parent, const QString& name );

    private:
        KListView  *m_entryView;
        EditorWidget *m_editWidget;
    };
}

#endif
