/**
 * token.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "token.h"

#include "undomanager.h"
#include "memento.h"

#include <qptrlist.h>
#include <qcolor.h>

namespace KCfgCreator
{

class Token::Private
{
public:
    QString name;

    /**
     * Modification count (pretty much == number of mementos created for this Token).
     */
    int  modified;
    bool undo;
    bool immutable;
    bool readOnly;
};

Token::Token( const QString& name, bool readOnly )
{
    d = new Private;
    d->name      = name;
    d->modified  = 0;
    d->undo      = true;
    d->immutable = false;
    d->readOnly  = readOnly;
}

Token::~Token()
{
    delete d;
    d = 0;
}

void
Token::setReadOnly( bool r )
{
    d->readOnly = r;
}

bool
Token::readOnly() const
{
    return d->readOnly;
}

void
Token::setName( const QString& name )
{
    addMemento();
    d->name = name;
    ++d->modified;
}

QString
Token::name() const
{
    return d->name;
}

bool
Token::modified() const
{
    return d->modified;
}

void
Token::addMemento()
{
    if ( undoEnabled() )
        UndoManager::Instance()->addMemento( createMemento() );
}

Memento*
Token::createMemento()
{
    return new Memento( this );
}

void
Token::enableUndo()
{
    d->undo = true;
}

void
Token::disableUndo()
{
    d->undo = false;
}

bool
Token::undoEnabled() const
{
    return d->undo;
}

void
Token::setImmutable( bool b )
{
    d->immutable = b;
}

bool
Token::immutable() const
{
    return d->immutable;
}

void
Token::incrementModificationCount()
{
    ++d->modified;
}

void
Token::decrementModificationCount()
{
    --d->modified;
}


}//end namespace
