/**
 * viewmanager.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "viewmanager.h"
#include "treeitems.h"
#include "kconfigproperty.h"
#include "grouptoken.h"
#include "entrytoken.h"
#include "configurationview.h"
#include "descriptionwidget.h"
#include "kernel.h"

#include "propertyeditor/propertyeditor.h"
#include "propertyeditor/propertylist.h"
#include "propertyeditor/multiproperty.h"

#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>
#include <kdebug.h>

#include <qlabel.h>
#include <qptrlist.h>

using namespace PropertyLib;

namespace KConfigEditor
{

ViewManager::ViewManager( ConfigurationView *appView, PropertyEditor *propertyView,
                          DescriptionWidget *docWidget, const char *name )
    : QObject( appView, name ), m_configView( appView ), m_propertyView( propertyView ),
      m_docWidget( docWidget )
{
    m_currentList = 0;
    connect( appView, SIGNAL(selectionChanged(QListViewItem*)),
             SLOT(slotSelectionChanged(QListViewItem*)) );

    connect( m_propertyView, SIGNAL(selectionChanged(QListViewItem*)),
             SLOT(slotChangeDescription(QListViewItem*)) );

    connect( m_propertyView, SIGNAL(clicked(QListViewItem*, const QPoint&, int)),
             SLOT(slotClicked( QListViewItem*, const QPoint&, int)));
}

ViewManager::~ViewManager()
{
    m_propertyView->clearProperties();
    m_currentList = 0;
}

void
ViewManager::slotSelectionChanged( QListViewItem *item )
{
    m_propertyView->clearProperties();

    GroupItem *group = dynamic_cast<GroupItem*>( item );
    if ( group ) {
        kernel->emitStatusMsg( group->group()->url().prettyURL() );
        m_currentList = new PropertyList();
        QDict<EntryToken> dict = group->group()->childEntries();
        QDictIterator<EntryToken> itr( dict );

        while ( itr.current() ) {
            m_currentList->addProperty( new KConfigProperty( itr.current() ) );
            ++itr;
        }
        m_propertyView->populateProperties( m_currentList );
    }
}

void
ViewManager::slotTokenRestored( Token * )
{
    kdDebug()<<"Token restored"<<endl;
}

void
ViewManager::slotClicked( QListViewItem */*it*/, const QPoint &/*p*/, int )
{
}

void
ViewManager::slotChangeDescription( QListViewItem *item )
{
    Q_ASSERT( m_currentList );
    QPtrList<Property> ml = m_currentList->properties( item->text( 0 ) );
    Property *prop = ml.first();

    KConfigProperty *kcprop = dynamic_cast<KConfigProperty*>( prop );
    if ( !kcprop )
        return;

    m_docWidget->setFromToken( kcprop->token() );
}

}

#include "viewmanager.moc"
