/*
 *  Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de>
 *  Copyright (C) 2003 Christoph Thielecke <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "useradminedit.h"
#include "useradmin.h"
#include "currentuserinfo.h"
#include <qmessagebox.h>
#include <qlabel.h>
#include "chpassdialog.h"



/**
 * class for editing users
 * @author Ole Behrmann
 	@author Christoph Thielecke
*/

UserAdminEdit::UserAdminEdit(QString url_system_passwd_file, QString url_system_group_file, QListViewItem *pCurrent) : UserAdminBaseAddUser() {

    setFixedSize ( QSize(width(),height())  ) ;

    connect(btnOk, SIGNAL (clicked()), this, SLOT (slotEditAll()));
    connect(chkBand, SIGNAL (clicked()), this, SLOT (slotResetBand()));

    //mode for kurlrequester
    kurlHomeDir->setMode(KFile::Directory);

    //get values from lstMainUser

    QString passwd, uid, gid, homeDir, chroot, fullName, downBand, upBand, maxFiles, maxSize;
    QString allRat, upRat, downRat, maxConn, allTime, frmTime, toTime, allCli, denCli, allLoc, denLoc;

    int cut;

    //  passwd
    textLabel3->setText("");
    textLabel4->setText("");
    pssPass->hide();
    pssRe->hide();

    chPassBtn = new KPushButton(basic);

    chPassBtn->setText(i18n("Change password..."));
    chPassBtn->setGeometry( QRect( 200, 80, 170, 29 ) );
    chPassBtn->show();

    connect (chPassBtn, SIGNAL(clicked()),this,SLOT(slotChPass()));


    // #0 login
    login = pCurrent->text(0);
    txtLogin->setText(login);

    txtLogin->setEnabled(false);

    // #1 full name
    fullName = pCurrent->text(1);
    txtName->setText(fullName);

    // #2 home Dir
    homeDir = pCurrent->text(2);
    kurlHomeDir->setURL(homeDir);

    // #3 chroot
    chroot = pCurrent->text(3);
    if (chroot.contains("N")) {
        rbNo->setChecked(true);
    }	else {
        rbYes->setChecked(true);
    }

    // #4 user UID
    uid = pCurrent->text(4);
    cmbUid->insertItem(uid,-1);

    // #5 group GID
    gid = pCurrent->text(5);
    cmbGid->insertItem(gid,-1);

    // #6 upload bandwidth
    upBand = pCurrent->text(6);
    if (!upBand.contains("-")) {
        checkUp->setChecked(true);
        chkBand->setChecked(true);

        cut = upBand.find("K");
        upBand.truncate(cut);

        spnUp->setValue(upBand.toInt());
    }

    // #7 download bandwidth
    downBand = pCurrent->text(7);
    if (!downBand.contains("-")) {
        checkDown->setChecked(true);
        chkBand->setChecked(true);

        cut = downBand.find("K");
        downBand.truncate(cut);

        spnDown->setValue(downBand.toInt());
    }

    // #8 max files
    maxFiles = pCurrent->text(8);
    if (!maxFiles.contains("-")) {
        checkFiles->setChecked(true);
        chkBand->setChecked(true);

        spnFiles->setValue(maxFiles.toInt());
    }

    // #9 max size
    maxSize = pCurrent->text(9);
    if (!maxSize.contains("-")) {
        chkBand->setChecked(true);
        checkSize->setChecked(true);

        cut = maxSize.find("M");
        maxSize.truncate(cut);

        spnSize->setValue(maxSize.toInt());
    }

    // #10 ratio outgoing
    allRat = pCurrent->text(10);
    if (!allRat.contains("-")) {
        chkRat->setChecked(true);
        upRat = allRat;
        cut = allRat.find(":");
        upRat.truncate(cut);
        spnRatUp->setValue(upRat.toInt());

        downRat = allRat.remove(0,cut+1);
        spnRatDwn->setValue(downRat.toInt());

    }

    // #11 time restrictions
    allTime = pCurrent->text(11);
    if (allTime.length() != 1) {
        chkTime->setChecked(true);

        frmTime = allTime;
        cut = allTime.find("-");
        frmTime.truncate(cut);
        spnTimeFrm->setValue(frmTime.toInt());

        toTime = allTime.remove(0,cut+1);
        spnTimeTo->setValue(toTime.toInt());
    }

    // #12 max connections
    maxConn = pCurrent->text(12);
    if (!maxConn.contains("-")) {
        chkBand->setChecked(true);
        checkConn->setChecked(true);

        spnConn->setValue(maxConn.toInt());
    }

    int IPcount, i, seek ;
    QString addIP;
    // #13 allowed local IPs
    allLoc = pCurrent->text(13);
    if (!allLoc.isEmpty()) {
        chkAcc->setChecked(true);
        IPcount = allLoc.contains(",");

        btnIPallowLocalRem->setEnabled(true);

        for( i = 0; i <= IPcount; i++ ) {
            addIP = allLoc;
            seek = addIP.find(",");
            addIP.truncate(seek);
            lst3->insertItem(addIP);

            allLoc.remove(0,seek+1);


        }
    }
    // #14 denied local IPs
    denLoc = pCurrent->text(14);
    if (!denLoc.isEmpty()) {
        chkAcc->setChecked(true);
        IPcount = denLoc.contains(",");

        btnIPdenyLocalRem->setEnabled(true);

        for( i = 0; i <= IPcount; i++ ) {
            addIP = denLoc;
            seek = addIP.find(",");
            addIP.truncate(seek);
            lst4->insertItem(addIP);

            denLoc.remove(0,seek+1);


        }
    }

    // #15 allowed client IPs
    allCli = pCurrent->text(15);
    if (!allCli.isEmpty()) {
        chkAcc->setChecked(true);
        IPcount = allCli.contains(",");

        btnIPallowRem->setEnabled(true);

        for( i = 0; i <= IPcount; i++ ) {
            addIP = allCli;
            seek = addIP.find(",");
            addIP.truncate(seek);
            lst1->insertItem(addIP);

            allCli.remove(0,seek+1);


        }
    }

    // #16 denied client IPs
    denCli = pCurrent->text(16);
    if (!denCli.isEmpty()) {
        chkAcc->setChecked(true);
        IPcount = denCli.contains(",");

        btnIPdenyRem->setEnabled(true);

        for( i = 0; i <= IPcount; i++ ) {
            addIP = denCli;
            seek = addIP.find(",");
            addIP.truncate(seek);
            lst2->insertItem(addIP);

            denCli.remove(0,seek+1);


        }
    }

    //get values for user and group comboboxes

    //users
    QFile flGetSysUser(url_system_passwd_file);
    if ( flGetSysUser.open(IO_ReadOnly)) {
        QTextStream txtsGetSysUser( &flGetSysUser );
        QString readSysUser;

        while(!txtsGetSysUser.eof()) {
            readSysUser = txtsGetSysUser.readLine();
            int indexUid;
            indexUid = readSysUser.find(":");
            readSysUser.truncate(indexUid);

            cmbUid->insertItem(readSysUser, -1);
        }
        flGetSysUser.close();
    } else {
        // now using variable for path
        KMessageBox::sorry(this,i18n("Unable to open "+url_system_passwd_file+" !"));
    }

    //groups
    QFile flGetSysGrp(url_system_group_file);
    if ( flGetSysGrp.open(IO_ReadOnly)) {
        QTextStream txtsGetSysGrp( &flGetSysGrp );
        QString readSysGrp;


        while(!txtsGetSysGrp.eof()) {
            readSysGrp = txtsGetSysGrp.readLine();
            int indexGid;
            indexGid = readSysGrp.find(":");
            readSysGrp.truncate(indexGid);

            cmbGid->insertItem(readSysGrp, -1);
        }
        flGetSysGrp.close();
    } else {
        // now using variable for path
        KMessageBox::sorry(this,i18n("Unable to open "+url_system_group_file+" !"));
    }
    close();
}


void UserAdminEdit::slotEditAll() {

    QString passwd,login, uid, gid, homeDir, fullName, downBand, upBand, maxFiles, maxSize;
    QString upRat, downRat, maxConn, frmTime, toTime, allCli, denCli, allLoc, denLoc;

    prcEdit = new QProcess(this);

    prcEdit->addArgument("pure-pw");
    prcEdit->addArgument("usermod");

    // #1 login
    login = txtLogin->text();
    prcEdit->addArgument(login); //<< login;

    // #2 uid
    uid = cmbUid->currentText();
    if (uid != "root" && uid != "0") {
        prcEdit->addArgument("-u"); //<< "-u";
        prcEdit->addArgument(uid);  //<< uid;
    } else {
        KMessageBox::sorry(this,i18n("UID is not allowed to be root!"));
    }

    // #3 gid
    gid = cmbGid->currentText();
    if (gid != "root" && gid != "0") {
        prcEdit->addArgument("-g");// << "-g"+gid;
        prcEdit->addArgument(gid);// << "-g"+gid;
    } else {
        KMessageBox::sorry(this,i18n("GID is not allowed to be root!"));
    }

    // #4 home dir
    homeDir = kurlHomeDir->url();
    if (rbYes->isChecked() == TRUE) {
        prcEdit->addArgument("-d"); //<< "-d";
        prcEdit->addArgument(homeDir); //<< homeDir;

    } else {
        prcEdit->addArgument("-D"); //<< "-D";
        prcEdit->addArgument(homeDir); //<< homeDir;
    }

    // #5 full name
    fullName = txtName->text();
    if (!fullName.isEmpty()) {
        prcEdit->addArgument("-c"); //<< "-c";
        prcEdit->addArgument(fullName); //<< fullName;
    }

    // #6 Achtung Pfad korrekt setzen
    //prcEdit << "-f/etc/pureftpd.passwd";

    // #7 download bandwidth

    downBand = spnDown->text();

    if (checkDown->isChecked()) {
        prcEdit->addArgument("-t"); //<< "-t";
        prcEdit->addArgument(downBand); //<< "downBand;
    } else {

        prcEdit->addArgument("-t");
        prcEdit->addArgument("""");
    }

    // #8 upload bandwidth
    upBand = spnUp->text();
    if (checkUp->isChecked()) {
        prcEdit->addArgument("-T"); //<< "-T";
        prcEdit->addArgument(upBand); //<< upBand;
    } else {

        prcEdit->addArgument("-T");
        prcEdit->addArgument("""");
    }

    // #9 max number of files
    maxFiles = spnFiles->text();
    if (checkFiles->isChecked()) {
        prcEdit->addArgument("-n"); //<< "-n";
        prcEdit->addArgument(maxFiles); //<< maxFiles;
    } else {

        prcEdit->addArgument("-n");
        prcEdit->addArgument("""");
    }

    // #10 max size
    maxSize = spnSize->text();
    if (checkSize->isChecked()) {
        prcEdit->addArgument("-N"); //<< "-N";
        prcEdit->addArgument(maxSize); //<< maxSize;
    } else {

        prcEdit->addArgument("-N");
        prcEdit->addArgument("""");
    }

    // #11 upload ratio
    upRat = spnRatUp->text();
    if (chkRat->isChecked()) {
        prcEdit->addArgument("-q"); //<< "-q";
        prcEdit->addArgument(upRat); //<< upRat;
    } else {

        prcEdit->addArgument("-q");
        prcEdit->addArgument("""");
    }

    // #12 download ratio
    downRat = spnRatDwn->text();
    if (chkRat->isChecked()) {
        prcEdit->addArgument("-Q"); //<< "-Q";
        prcEdit->addArgument(downRat); //<< downRat;
    } else {

        prcEdit->addArgument("-Q");
        prcEdit->addArgument("""");
    }

    // #13 allow client host
    int lst1Count = lst1->count();
    int i1;
    for(i1 = 0; i1 < lst1Count; i1++) {
        allCli += lst1->text(i1)+",";
    }

    if (!allCli.isEmpty()) {
        allCli.truncate(allCli.length()-1);
        prcEdit->addArgument("-r"); //<< "-r";
        prcEdit->addArgument(allCli); //<< allCli;
    } else { //09.04
        prcEdit->addArgument("-r"); //09.04
        prcEdit->addArgument(""""); // 09.04
    }



    // #14 deny client host
    int lst2Count = lst2->count();
    int i2;
    for(i2 = 0; i2 < lst2Count; i2++) {
        denCli += lst2->text(i2)+",";
    }

    if (!denCli.isEmpty()) {
        denCli.truncate(denCli.length()-1);
        prcEdit->addArgument("-R"); //<< "-R";
        prcEdit->addArgument(denCli); //<< denCli;
    } else {//09.04
        prcEdit->addArgument("-R");//09.04
        prcEdit->addArgument("""");//09.04
    }


    // #15 allow local host
    int lst3Count = lst3->count();
    int i3;
    for(i3 = 0; i3 < lst3Count; i3++) {
        allLoc += lst3->text(i3)+",";
    }

    if (!allLoc.isEmpty()) {
        allLoc.truncate(allLoc.length()-1);
        prcEdit->addArgument("-i"); //<< "-i";
        prcEdit->addArgument(allLoc); //<< allLoc;
    } else {//09.04
        prcEdit->addArgument("-i");//09.04
        prcEdit->addArgument("""");//09.04
    }

    // #16 deny local host
    int lst4Count = lst4->count();
    int i4;
    for(i4 = 0; i4 < lst4Count; i4++) {
        denLoc += lst4->text(i4)+",";
    }

    if (!denLoc.isEmpty()) {
        denLoc.truncate(denLoc.length()-1);
        prcEdit->addArgument("-I"); // << "-I";
        prcEdit->addArgument(denLoc); // << denLoc;
    } else {//09.04
        prcEdit->addArgument("-I");//09.04
        prcEdit->addArgument("""");//09.04
    }


    // #17 max number of concurrent sessions
    maxConn = spnConn->text();
    if (checkConn->isChecked()) {
        prcEdit->addArgument("-y"); //<< "-y";
        prcEdit->addArgument(maxConn); //<< maxConn;
    } else {

        prcEdit->addArgument("-y");
        prcEdit->addArgument("""");
    }

    // #18 time restrictions
    frmTime = spnTimeFrm->text();
    if (frmTime < 1000) {
        // QString frmTimeLo;
        frmTime = "0"+frmTime;
    }

    toTime = spnTimeTo->text();
    if (toTime < 1000) {
        // QString toTimeLo;
        toTime = "0"+toTime;
    }

    /* if (!chkTime->isChecked()) {
         prcEdit->addArgument("-z -m");
         //prcEdit->addArgument(frmTime+"-"+toTime);
    }*/

    if (chkTime->isChecked()) {
        prcEdit->addArgument("-z");
        prcEdit->addArgument(frmTime+"-"+toTime);
        //prcEdit << "-z"+frmTime+"-"+toTime;
    } else {

        prcEdit->addArgument("-z");
        prcEdit->addArgument("""");
    }

    prcEdit->addArgument("-m");

    connect( prcEdit, SIGNAL(readyReadStderr()), this, SLOT(slotReadStdout()));
    connect( prcEdit, SIGNAL(processExited()), this, SLOT(slotClosed()));


    /*
    QString d1;
     QStringList arglist = prcEdit->arguments ();

      for ( QStringList::Iterator it = arglist.begin(); it != arglist.end(); ++it ) {
          d1+= *it + " ";
      }

      KMessageBox::sorry(this,i18n(d1));
    */
    //start process
    if (!prcEdit->start()) {
        KMessageBox::sorry(this,i18n("Unable to start process!"));
    }

    if (!login.isEmpty() && !uid.isEmpty() && !gid.isEmpty() && !homeDir.isEmpty() ) {
        this->close();
    } else {
        KMessageBox::sorry(this,i18n("Login, Home Dir, UID and GID have to have values!"));
    }
}


void UserAdminEdit::slotAbort() {
    this->close();
}

void UserAdminEdit::slotClosed() {
    emit editDialogClosed();
}

void UserAdminEdit::slotResetBand() {
    if (!chkBand->isChecked()) {
        checkUp->setChecked(false);
        spnUp->setValue(0);

        checkDown->setChecked(false);
        spnDown->setValue(0);

        checkFiles->setChecked(false);
        spnFiles->setValue(0);

        checkSize->setChecked(false);
        spnSize->setValue(0);

        checkConn->setChecked(false);
        spnConn->setValue(0);
    }
}


void UserAdminEdit::slotEnBand() {
    if (!chkBand->isChecked()) {
        checkFiles->setEnabled(FALSE);
        checkConn->setEnabled(FALSE);
        checkUp->setEnabled(FALSE);
        checkDown->setEnabled(FALSE);
        checkSize->setEnabled(FALSE);

    } else {
        checkFiles->setEnabled(TRUE);
        checkConn->setEnabled(TRUE);
        checkUp->setEnabled(TRUE);
        checkDown->setEnabled(TRUE);
        checkSize->setEnabled(TRUE);

    }
}

void UserAdminEdit::slotEnAcc() {
    if (!chkAcc->isChecked()) {
        btnIPallow->setEnabled(FALSE);
        btnIPdeny->setEnabled(FALSE);
        btnIPallowLocal->setEnabled(FALSE);
        btnIPdenyLocal->setEnabled(FALSE);
    } else {
        btnIPallow->setEnabled(TRUE);
        btnIPdeny->setEnabled(TRUE);
        btnIPallowLocal->setEnabled(TRUE);
        btnIPdenyLocal->setEnabled(TRUE);
    }
}

void UserAdminEdit::slotEnTime() {
    if (!chkTime->isChecked()) {
        spnTimeFrm->setEnabled(FALSE);
        spnTimeTo->setEnabled(FALSE);
    } else {
        spnTimeFrm->setEnabled(TRUE);
        spnTimeTo->setEnabled(TRUE);
    }
}


void UserAdminEdit::slotEnRatio() {
    if (!chkRat->isChecked()) {
        spnRatUp->setEnabled(FALSE);
        spnRatDwn->setEnabled(FALSE);
    } else {
        spnRatUp->setEnabled(TRUE);
        spnRatDwn->setEnabled(TRUE);
    }
}

void  UserAdminEdit::slotCliIpAcc() {
    dialog1 = new KLineEditDlg(i18n("Enter allowed client ip"),"",this);
    connect(dialog1, SIGNAL (okClicked()), this, SLOT (slotCliIpAccAdd()));
    dialog1->exec();
}
void  UserAdminEdit::slotCliIpAccAdd() {
    lst1->insertItem(dialog1->text(),-1);
    btnIPallowRem->setEnabled(true);
}

void UserAdminEdit::slotCliIpAccRem() {
    int lst1Curr = lst1->currentItem();
    lst1->removeItem(lst1Curr);

    if (lst1->count() == 0)
        btnIPallowRem->setEnabled(false);
}

void  UserAdminEdit::slotCliIpDen() {
    dialog2 = new KLineEditDlg(i18n("Enter denied client ip"),"",this);
    connect(dialog2, SIGNAL (okClicked()), this, SLOT (slotCliIpDenAdd()));
    dialog2->exec();
}
void  UserAdminEdit::slotCliIpDenAdd() {
    lst2->insertItem(dialog2->text(),-1);
    btnIPdenyRem->setEnabled(true);
}

void UserAdminEdit::slotCliIpDenRem() {
    int lst2Curr = lst2->currentItem();
    lst2->removeItem(lst2Curr);

    if (lst2->count() == 0)
        btnIPdenyRem->setEnabled(false);
}

void  UserAdminEdit::slotLocIpAcc() {
    dialog3 = new KLineEditDlg(i18n("Enter allowed local ip"),"",this);
    connect(dialog3, SIGNAL (okClicked()), this, SLOT (slotLocIpAccAdd()));
    dialog3->exec();
}
void  UserAdminEdit::slotLocIpAccAdd() {
    lst3->insertItem(dialog3->text(),-1);
    btnIPallowLocalRem->setEnabled(true);
}

void UserAdminEdit::slotLocIpAccRem() {
    int lst3Curr = lst3->currentItem();
    lst3->removeItem(lst3Curr);

    if (lst3->count() == 0)
        btnIPallowLocalRem->setEnabled(false);
}

void  UserAdminEdit::slotLocIpDen() {
    dialog4 = new KLineEditDlg(i18n("Enter denied local ip"),"",this);
    connect(dialog4, SIGNAL (okClicked()), this, SLOT (slotLocIpDenAdd()));
    dialog4->exec();
}
void  UserAdminEdit::slotLocIpDenAdd() {
    lst4->insertItem(dialog4->text(),-1);
    btnIPdenyLocalRem->setEnabled(true);
}

void UserAdminEdit::slotLocIpDenRem() {
    int lst4Curr = lst4->currentItem();
    lst4->removeItem(lst4Curr);

    if (lst4->count() == 0)
        btnIPdenyLocalRem->setEnabled(false);
}

void UserAdminEdit::slotEnBandwFiles() {
    if (!checkFiles->isChecked()) {
        spnFiles->setEnabled(FALSE);
    } else {
        spnFiles->setEnabled(TRUE);
    }

}

void UserAdminEdit::slotEnBandwSize() {
    if (!checkSize->isChecked()) {
        spnSize->setEnabled(FALSE);
    } else {
        spnSize->setEnabled(TRUE);
    }

}

void UserAdminEdit::slotEnBandwUp() {
    if (!checkUp->isChecked()) {
        spnUp->setEnabled(FALSE);
    } else {
        spnUp->setEnabled(TRUE);
    }

}

void UserAdminEdit::slotEnBandwDown() {
    if (!checkDown->isChecked()) {
        spnDown->setEnabled(FALSE);
    } else {
        spnDown->setEnabled(TRUE);
    }

}

void UserAdminEdit::slotEnBandwConn() {
    if (!checkConn->isChecked()) {
        spnConn->setEnabled(FALSE);
    } else {
        spnConn->setEnabled(TRUE);
    }

}


UserAdminEdit::~UserAdminEdit() {}

void UserAdminEdit::slotChPass() {

    QString newPassword;
    ChPassDialog *d = new ChPassDialog(login) ;
    d->show();

}


