#include "TabView.h"

TabView::TabView(QWidget *parent, const char *name)
	: KListView(parent, name)
{
    setFocusPolicy(QWidget::StrongFocus);
    //setAutoUpdate(TRUE);
    //lbox.setAutoUpdate(TRUE);
    
}

void TabView::fitAll(void)
{
    for(int i=0; i<columns(); i++){
	int res = 80;
	/*
	  QFontMetrics metrics(tab->tableFont());
	  int headWidth = metrics.width(tab->text(0, i));
	  res = headWidth;
	*/
	setColumnWidth(i, res);
    }
    repaint();
}

/**
	Set the titles of each columns using a string where column names are 
	separated by a tab ('\t').
*/
void TabView::setColumns(QString columns)
{
    if(columns.isEmpty())
	return;
    int index = 0;
    bool fin = false;
    int i = 0;
    while(!fin) {
	int index2 = columns.find('\t', index);
	if(index2 == -1) {
	    index2 = columns.length();
	    fin = true;
	}
	QString col = columns.mid(index, index2-index);
	addColumn(col);
	index = index2+1;
	i++;
    }
}

void TabView::clear()
{
    KListView::clear();
    //resizeList(0);
}

int TabView::count()
{
    return childCount();
}

int TabView::current()
{
    QListViewItem*item = currentItem();
    if (item == 0)
        return -1;
    return itemPos(item);
}

const char* TabView::text(int i)
{
    tmp_string = "";
    if (i<count() && columns()>0) {
        QListViewItem * item=0;
        item = firstChild();
        while (item && itemPos(item)<i) {
            item = item->nextSibling();
        }
        if (item) {
            tmp_string = item->text(0);
            for (int j = 1; j < columns();++j) {
                tmp_string+="\t";
                tmp_string+=item->text(j);
            }
        }
    }
    return tmp_string.c_str();
}

void TabView::line(int which,stringlist & target)
{
    target.resize(0);
    if (which<count()) {
        QListViewItem * item=0;
        item = firstChild();
        while (item && itemPos(item)<which) {
            item = item->nextSibling();
        }
        if (item) {
            for (int j=0; j < columns();++j) {
                target.push_back(item->text(j).latin1());
            }
        }
    }
}
