#!/bin/bash


# slackbuild script for libkexif
# Author: Mark Tucker
# Created: Sep 18, 2005
# Changes:
#        Sep 18, 2005 - initial creation

#
#----------------------------------------------------------------------
umask 0022

#----------------------------------------
# include the common functions
#----------------------------------------
if [ -r ./sbuild.functions ]; then
    . ./sbuild.functions
else
    echo Cannot read file `pwd`/sbuild.functions
    echo Exiting....
    echo
    exit
fi

#----------------------------------------
# Set locations for temp directories
#----------------------------------------
# location of source code archive
srcdir=`pwd`/SRC
workdir=`pwd`


#----------------------------------------
# Package variables
#----------------------------------------
source="libkexif-0.2.1.tar.bz2"
pkgname="libkexif"
pkgver="0.2.1"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
realname="Mark Tucker"
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
set_workdir

# unpack the source
echo Unpacking the source...
tar -xjf $srcdir/$source


cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS



#----------------------------------------
# Build the package and install
#----------------------------------------
# configure 
conf_opts="--prefix=/opt/kde"
#    > $workdir/config.output 2>&1
run_configure $conf_opts

# make
run_make

# Set target directory
set_target

# install
run_makeinstall


echo finishing install...


# create install dir
mkdir $target/install

#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
        |-----handy-ruler------------------------------------------------------|
$pkgname: $pkgname $pkgver
$pkgname:
$pkgname: Libkexif is a library for manipulating EXIF information embedded in
$pkgname: images. It currently supports viewing of all EXIF information via
$pkgname: libexif. It also supports the modification of a few attributes in a
$pkgname: save way that preserves all other EXIF information in the file.
$pkgname:
$pkgname:
$pkgname:
$pkgname:
$pkgname: Packaged by $realname for $slackver / KDE 3.4.2
END


# create documentation directory
create_docdir

# fix group on bin directories.
fix_bingrp

# strip  bin files
strip_bin

# strip lib files
strip_libs

# check for uncompressed man pages
compr_man

# makepkg
create_pkg

exit