#!/bin/bash


# slackbuild script for libkipi
# Author: Mark Tucker
# Created: Sep 18, 2005
# Changes:
#        Jul 31, 2004 - initial creation
#        Oct 8, 2004 - updated for 20040919
#        Oct 24, 2004 - updated for ver. 0.1
#        Apr 1, 2005 - updated for ver. 0.1.1
#        Sep 18, 2005 - Updated to use sbuild.functions file

#
#----------------------------------------------------------------------
umask 0022

#----------------------------------------
# include the common functions
#----------------------------------------
if [ -r ./sbuild.functions ]; then
    . ./sbuild.functions
else
    echo Cannot read file `pwd`/sbuild.functions
    echo Exiting....
    echo
    exit
fi

#----------------------------------------
# Set locations for temp directories
#----------------------------------------
# location of source code archive
srcdir=`pwd`/SRC
workdir=`pwd`


#----------------------------------------
# Package variables
#----------------------------------------
source="libkipi-0.1.1.tar.bz2"
pkgname="libkipi"
pkgver="0.1.1"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
realname="Mark Tucker"
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
set_workdir

# unpack the source
echo Unpacking the source...
tar -xjf $srcdir/$source


cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS



#----------------------------------------
# Build the package and install
#----------------------------------------
# configure 
conf_opts="--prefix=/opt/kde"
#    > $workdir/config.output 2>&1
run_configure $conf_opts

# make
run_make

# Set target directory
set_target

# install
run_makeinstall


echo finishing install...


# create install dir
mkdir $target/install

#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
       |-----handy-ruler------------------------------------------------------|
$pkgname: $pkgname $pkgver
$pkgname:
$pkgname: library to enable the Digikam  Plugins for various KDE graphical 
$pkgname: applications.
$pkgname:
$pkgname:
$pkgname:
$pkgname:
$pkgname: http://gwenview.sourceforge.net/
$pkgname:
$pkgname: Packaged by Mark Tucker for Slackware 10.1 / KDE 3.4
END

# create documentation directory
create_docdir

# fix group on bin directories.
fix_bingrp

# strip  bin files
strip_bin

# strip lib files
strip_libs

# check for uncompressed man pages
compr_man

# makepkg
create_pkg

exit