// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore, <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef LIBKDETVACTIONS_H
#define LIBKDETVACTIONS_H

#include <qobject.h>
#include <qptrlist.h>

class KAction;
class KRadioAction;

class LCDNumberAction;
class SliderAction;
class DeviceAction;

class Kdetv;
class KdetvWidget;
class KdetvSourcePlugin;

/**
 * Creates and manages the KActions for a Kdetv object.
 *
 * @author Richard Moore, rich@kde.org
 */
class LibKdetvActions : public QObject
{
    Q_OBJECT

public:
    LibKdetvActions( Kdetv *ktv, const char *name=0 );
    ~LibKdetvActions();

    void createActions( KActionCollection *acts );
    const QPtrList<KAction>& devicesActionList( KActionCollection *acts );
    const QPtrList<KAction>& audioModesActionList( KActionCollection *acts );

    KAction *channelDown() const { return chanDown; }
    KAction *channelUp() const { return chanUp; }
    KAction *channelWizard() const { return chanWiz; }
    KAction *channelLoadDefaults() const { return chanLoadDefaults; }
    KAction *channelImportLegacy() const { return chanImportLegacy; }
    KAction *channelOpen() const { return chanOpen; }
    KAction *channelImport() const { return chanImport; }
    KAction *channelEdit() const { return chanEdit; }

    KAction *pictureSettings() const { return picSettings; }

    SliderAction *volumeSlider() const { return volSlider; }
    KAction *volumeMute() const { return volMute; }
    KAction *volumeUp() const { return volUp; }
    KAction *volumeDown() const { return volDown; }

    KAction *snapshot() const { return snap; }
    KAction *settings() const { return showSettings; }
    KAction *keys() const { return showKeys; }

    LCDNumberAction *channel() const { return chan; }

public slots:
    void deviceChanged( const QString& );
    void updateSlider(int, int);
    void updateMuteButton(bool);
    void enableAudioActions(bool enable);
    void checkAudioMode(const QString& mode);

signals:
    void launchBindings();

private:
    void checkDevice(const QString& dev);

    Kdetv *ktv;

    LCDNumberAction *chan;
    KAction *chanLoadDefaults;
    KAction *chanImportLegacy;
    KAction *chanOpen;
    KAction *chanImport;
    KAction *chanDown;
    KAction *chanUp;
    KAction *chanWiz;
    KAction *chanEdit;

    KAction *picSettings;

    SliderAction *volSlider;
    KToggleAction *volMute;
    KToggleAction *sleepTime;
    KAction *volUp;
    KAction *volDown;
    KAction *prevChannel;

    QPtrList<KAction> _devicesActionList;
    QPtrList<KAction> _audioModeActionList;

    KAction *snap;
    KAction *showSettings;
    KAction *showKeys;
};

#endif

