# Edit the following if you want to provide an RPM
%define packager Dirk Ziegelmeier <dziegel@gmx.de>
%define release  1
%define epoch    1
%define distro   suse82kde321
%define vendor   The kdetv developers

# Don't change anything below here
%define version      %(cat kdetv_version.h | sed \"s/.*\\\"\\(.*\\)\\\"/\\1/\")
%define _rpmfilename %%{ARCH}/%{name}-%{version}-%{release}.%{distro}.%%{ARCH}.rpm

Summary:   KDE TV Application
Name:      kdetv
Version:   %{version}
Release:   %{release}
Epoch:     %{epoch}
Copyright: GPL
Vendor:    %{vendor}
URL:       http://www.kwintv.org
Packager:  %{packager}
Group:     Applications/Multimedia
Source:    http://dziegel.free.fr/%{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}
Prefix:    %(kde-config --prefix)
Provides:  tv-viewer kdetv kv4lsetup
Requires:  qt3      >= %(rpm -q --queryformat '%%{version}' qt3)
Requires:  kdelibs3 >= %(rpm -q --queryformat '%%{version}' kdelibs3)
Requires:  zvbi     >= %(rpm -q --queryformat '%%{version}' zvbi)
Obsoletes: kwintv qtvision kwintv3

%description
KDE application to watch TV on your desktop.
Note: It was formerly known as QtVision or KWinTV3.

%prep
if test `whoami` != "root"; then
  echo "You need to build this as root, there is a SUID root program involved (kv4lsetup)"
  /bin/false
fi

%setup 

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" \
./configure --prefix=%{prefix} $LOCALFLAGS
make

%install
make install-strip DESTDIR="$RPM_BUILD_ROOT"
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,'  > $RPM_BUILD_DIR/filelist.kdetv
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,'            >> $RPM_BUILD_DIR/filelist.kdetv
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,'            >> $RPM_BUILD_DIR/filelist.kdetv

%clean
# sanity check (I know I'm paranoid, but we are root here...)
test "$RPM_BUILD_ROOT" == "/" && /bin/false
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -f  $RPM_BUILD_DIR/filelist.kdetv

%files -f ../filelist.kdetv

%changelog
* Sun Mar 28 2004 - Dirk Ziegelmeier <dziegel@gmx.de>
Intitial version. Inspired by k3b. For further changes refer to CVS history.
