/***************************************************************************
                          kconnectionlist.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONNECTIONLIST_H
#define KCONNECTIONLIST_H

#include "connectionlist.h"
#include "ksynkconnection.h"
#include <qdict.h>
#include "ktransferkio.h"


/**Implements the list of connections
 *@author Jonathon Sim
 */

class KConnectionList : public ConnectionList
{
    Q_OBJECT

public:
    KConnectionList(QWidget* parent = 0, const char* name = 0);
    ~KConnectionList();
    /** Modifies the connection that is currently selected. */
    void changeSelectedConnection(const KSynkConnection newconnection);
    void changeConnection( const QString& name,
                           const KSynkConnection& conn );

    /** Removes the currently selected connection */
    void deleteSelectedConnection();

    void deleteConnection( const QString& name );

    /** Adds a connection to the list */
    void addConnection(const KSynkConnection& newconnection);

    /** Returns the currently selected connection */
    const KSynkConnection * selectedConnection();

    /** A pointer to the given connection, or 0 if there is none */
    const KSynkConnection* getConnection(const QString & name) const;

    bool hasConnection( const QString& name ) const { return (getConnection( name ) != 0L); }

    /** Returns the list of  connections */
    typedef QPtrList<KSynkConnection> List;
    List * connectionList();

    void setInitialSelection();

signals:
    /** Emmitted when the selection changes */
    void signalSelectionChanged();

protected:
    QListViewItem *findItemByName( const QString& name );
    QDict<KSynkConnection> connectiondict;

protected slots:
    /** Handles change of selection */
    void slotSelectionChanged();

};

#endif
