/*
    This file is borrowed from KOrganizer and modified for KBudget.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef _KDATEEDIT_H
#define _KDATEEDIT_H
// $Id: kdateedit.h,v 1.1 2002/08/31 02:04:30 richard Exp $	

#include <qhbox.h>
#include <qvbox.h>
#include <qdatetime.h>

class KLineEdit;
class KPushButton;
class KDatePicker;
class KDateValidator;

class KDateEdit : public QHBox
{
    Q_OBJECT
  public:
    KDateEdit(QWidget *parent=0, const char *name=0);
    virtual ~KDateEdit();

    bool inputIsValid();

  signals:
    void dateChanged(QDate);

  public slots:
    void setDate(QDate date);
    QDate getDate() const;
    void setEnabled(bool on);

  protected slots:
    void toggleDatePicker();
    void lineEnterPressed();
 
  private:
    KPushButton *mDateButton;
    KLineEdit *mDateEdit;
    KDatePicker *mDatePicker;
    QVBox *mDateFrame;
    bool visible;
};

#endif
