/*
    This file is borrowed from KOrganizer and modified for KBudget.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.

    $Id: kdateedit.cpp,v 1.2 2002/09/04 02:04:16 richard Exp $
*/

#include <qpixmap.h>
#include <klineedit.h>
#include <kpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdatepik.h>
#include <knotifyclient.h>

#include "kdateedit.h"
#include "kdateedit.moc"

#warning This class is very useful, it should be in kdeui

KDateEdit::KDateEdit(QWidget *parent, const char *name)
  : QHBox(parent, name), visible(false)
{
  mDateEdit = new KLineEdit(this);
  mDateEdit->setText(KGlobal::locale()->formatDate(QDate::currentDate(),true));
  setFocusProxy(mDateEdit);

  QPixmap pixmap = SmallIcon("smallcal");
  mDateButton = new KPushButton(this);
  mDateButton->setPixmap(pixmap);
  
  mDateFrame = new QVBox(0,0,WType_Popup);
  mDateFrame->setFrameStyle(QFrame::PopupPanel | QFrame::Raised);
//  mDateFrame->setFixedSize(200,200);
//  mDateFrame->setLineWidth(3);
  mDateFrame->hide();

  mDatePicker = new KDatePicker(mDateFrame,QDate::currentDate());

  connect(mDateEdit,SIGNAL(returnPressed()),SLOT(lineEnterPressed()));

  connect(mDateButton,SIGNAL(clicked()),SLOT(toggleDatePicker()));

  connect(mDatePicker,SIGNAL(dateSelected(QDate)),SLOT(setDate(QDate)));
  connect(mDatePicker,SIGNAL(dateSelected(QDate)),SIGNAL(dateChanged(QDate)));
  connect(mDatePicker,SIGNAL(dateSelected(QDate)),mDateFrame,SLOT(hide()));
}

KDateEdit::~KDateEdit()
{
  delete mDateFrame;
}

void KDateEdit::setDate(QDate newDate)
{
  if (!newDate.isValid())
    return;
  visible = false;
  mDateEdit->setText(KGlobal::locale()->formatDate(newDate,true));
}

void KDateEdit::setEnabled(bool on)
{
  mDateEdit->setEnabled(on);
  mDateButton->setEnabled(on);
}

QDate KDateEdit::getDate() const
{
  QDate date = KGlobal::locale()->readDate(mDateEdit->text());

  if (date.isValid()) {
    return date;
  } else {
    KNotifyClient::beep();
    return QDate::currentDate();
  }
}

void KDateEdit::toggleDatePicker()
{
  if(visible)
    mDateFrame->hide();
  else {
  	QPoint tmpPoint = mapToGlobal(mDateButton->geometry().bottomRight());

//	QSize size = mDateFrame->frameSize();
//	mDateFrame->setGeometry(tmpPoint.x()-size.width(), tmpPoint.y(), size.width(), size.height());
	mDateFrame->setGeometry(tmpPoint.x()-250, tmpPoint.y(), 250, 250);

  	QDate date = KGlobal::locale()->readDate(mDateEdit->text());
  	if(date.isValid()) {
    	mDatePicker->setDate(date);
  	} else {
    	mDatePicker->setDate(QDate::currentDate());
  	}
  	mDateFrame->show();
  }
  visible = !visible;
}


void KDateEdit::lineEnterPressed()
{
  QDate date = KGlobal::locale()->readDate(mDateEdit->text());

  if(date.isValid()) {
    emit(dateChanged(date));
  } else {
    KNotifyClient::beep();
  }
}

bool KDateEdit::inputIsValid()
{
  QDate date = KGlobal::locale()->readDate(mDateEdit->text());
  return date.isValid();
}
