// -*- c++ -*-

/*
 *  Copyright (C) 2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBED_PIXMAP_IMP_H
#define KJSEMBED_PIXMAP_IMP_H

#include <kjsembed/jsobjectproxy_imp.h>

#include <kpixmap.h>
#include <kpixmapeffect.h>

namespace KJSEmbed {
namespace Bindings {

/**
 * QObject Binding for QPixmap.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: pixmap_imp.h,v 1.1 2004/11/24 02:07:04 staikos Exp $
 */
class Pixmap : public JSProxyImp
{
/*
    Q_   OBJECT
    Q_PROPERTY( int width READ width )
    Q_PROPERTY( int height READ height )
    Q_PROPERTY( QSize size READ size WRITE resize )
    Q_PROPERTY( int depth READ depth )
    Q_PROPERTY( QPixmap pixmap READ pixmap WRITE setPixmap )
    Q_PROPERTY( bool isNull READ isNull )
*/
    /** Identifiers for the methods provided by this class. */
    enum MethodId { MethodisNull, Methodwidth, Methodheight, Methodsize, Methodrect, Methoddepth, Methodresize, Methodfill, Methodmask, MethodsetMask, MethodcreateHeuristicMask };
    
public:
    Pixmap( KJS::ExecState *exec, int id  );
    virtual ~Pixmap();
    
    static void addBindings( KJS::ExecState *exec, KJS::Object &object );

    /** Returns true iff this object implements the call function. */
    virtual bool implementsCall() const { return true; }

    /** Invokes the call function. */
    virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );


    
private:
    bool isNull() const { return pix.isNull(); }

    int width() const { return pix.width(); }
    int height() const { return pix.height(); }
    QSize size() const { return pix.size(); }
    QRect rect() const { return pix.rect(); }

    int depth() const { return pix.depth(); }
    
    void resize( int w, int h );
    void resize( const QSize &size );
    void fill( const QColor &color );
        
    QPixmap mask();
    void setMask(const QPixmap& mask);
    QPixmap createHeuristicMask ( bool clipTight );
    // Pixmap Effects

    void gradient (const QColor &ca, const QColor &cb, KPixmapEffect::GradientType type, int ncols=3);
    void unbalancedGradient(const QColor &ca, const QColor &cb, KPixmapEffect::GradientType type, int xfactor=100, int yfactor=100, int ncols=3);
    void createTiled (QSize size);
    void intensity (float ratio);
    void channelIntensity (float ratio, KPixmapEffect::RGBComponent channel);
    void blend (float initial_intensity, const QColor &bgnd, KPixmapEffect::GradientType eff, bool anti_dir=false, int ncols=3);
    void hash (KPixmapEffect::Lighting lite=KPixmapEffect::NorthLite, unsigned int spacing=0, int ncols=3);
    void pattern (QSize size, const QColor &ca, const QColor &cb, int ncols=8);
    void fade (double val, const QColor &color);
    void toGray (bool fast=false);
    void desaturate (float desat=0.3);
    void contrast (int c);
    void dither (const QColor *palette, int size);
    void selectedPixmap (const QColor &col);

    // Image Capture
    void grabWindow(int winID, int x =0, int y = 0, int w = -1, int h = -1);

private:
    int mid;
    KPixmap pix;  // Temp now
};

} // namespace
} // namespace

#endif // KJSEMBED_PIXMAP_IMP_H
