/***************************************************************************
                          kstdatacollection-gui.cpp
                             -------------------
    begin                : July 15, 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qfile.h>

// include files for KDE
#include <kapplication.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprogress.h>

// application specific includes
#include "kst.h"
#include "kstdatacollection.h"

bool KST::dataTagNameNotUnique(const QString &tag, bool warn, void *p) {
  /* verify that the tag name is not empty */
  if (tag.stripWhiteSpace().isEmpty()) {
      if (warn) {
        KMessageBox::sorry(static_cast<QWidget*>(p), i18n("Empty tag names are not allowed."));
      }
      return true;
  }

  /* verify that the tag name is not used by a data object */
  KST::dataObjectList.lock().readLock();
  if (KST::dataObjectList.findTag(tag) != KST::dataObjectList.end()) {
    KST::dataObjectList.lock().readUnlock();
      if (warn) {
        KMessageBox::sorry(static_cast<QWidget*>(p), i18n("%1: this name is already in use. Change it to a unique name.").arg(tag));
      }
      return true;
  }
  KST::dataObjectList.lock().readUnlock();

  return false;
}

bool KST::vectorTagNameNotUnique(const QString &tag, bool warn, void *p) {
  /* verify that the tag name is not empty */
  if (tag.stripWhiteSpace().isEmpty()) {
      if (warn) {
        KMessageBox::sorry(static_cast<QWidget*>(p), i18n("Empty tag names are not allowed."));
      }
      return true;
  }

  /* verify that the tag name is not used by a data object */
  KST::vectorList.lock().readLock();
  KST::scalarList.lock().readLock();
  if (KST::vectorList.findTag(tag) != KST::vectorList.end() ||
      KST::scalarList.findTag(tag) != KST::scalarList.end()) {
    KST::scalarList.lock().readUnlock();
    KST::vectorList.lock().readUnlock();
      if (warn) {
        KMessageBox::sorry(static_cast<QWidget*>(p), i18n("%1: this name is already in use. Change it to a unique name.").arg(tag));
      }
      return true;
  }

  KST::scalarList.lock().readUnlock();
  KST::vectorList.lock().readUnlock();
  return false;
}


int KST::vectorToFile(KstVectorPtr v, QFile *f, void *p) {
  KstApp *app = KstApp::inst();
#define BSIZE 128
  char buf[BSIZE];

  v->readLock();

  int vSize = v->length();
  double *value = v->value();
  register int modval;
  QString saving = i18n("Saving vector %1").arg(v->tagName());

  modval = QMAX(vSize/100, 100);

  app->slotUpdateProgress(vSize, 0, QString::null);

  for (int i = 0; i < vSize; i++) {
    int l = snprintf(buf, BSIZE, "%g\n", value[i]);
    f->writeBlock(buf, l);
    if (i % modval == 0) {
      app->slotUpdateProgress(vSize, i, saving);
    }
  }

  v->readUnlock();

  app->slotUpdateProgress(0, 0, QString::null);

#undef BSIZE
  return 0;
}


void KST::removeCurveFromPlots(KstBaseCurve *c) {
  Kst2DPlotList pl = Kst2DPlot::globalPlotList();
  for (Kst2DPlotList::Iterator i = pl.begin(); i != pl.end(); ++i) {
    (*i)->Curves.remove(c);
  }
}


// vim: ts=2 sw=2 et
