// Qt includes
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstring.h>
#include <qobject.h>
#include <qobjectlist.h>

// KDE includes
#include <kdialogbase.h>
#include <klocale.h>
#include <kcombobox.h>

// kmtraceviewer includes
#include "KMtraceSuppressDialog.hh"
#include "KMtraceSuppressDialog.moc"
#include "KMtraceLeak.hh"

KMtraceSuppressDialog::KMtraceSuppressDialog( KMtraceLeak *leak,
                                              QWidget *parent,
                                              const char *name,
                                              bool modal )
: KDialogBase( parent, name, modal, i18n( "Suppressions" ),
               modal ? User1 | Cancel : User1 | Close, User1, false, i18n( "&Suppress" ) )
{
   QWidget *page = new QWidget( this );
   setMainWidget( page );
   
   QVBoxLayout *mainLayout = new QVBoxLayout( page, 0, spacingHint( ) );
   QGridLayout *topLayout = new QGridLayout( mainLayout );
   
   // message types to suppress (kmtrace knows only the MLK : Memory leak
   // at the moment)
   KComboBox *leakTypeCombo = new KComboBox( false, page, "leak type combo" );
   leakTypeCombo->insertItem( i18n( "MLK: Memory Leak" ) );

   QLabel *leakTypeLabel = new QLabel( leakTypeCombo, i18n( "&Leak type to suppress:" ), page );
   topLayout->addWidget( leakTypeLabel, 1, 0 );
   topLayout->addWidget( leakTypeCombo, 1, 1 );
   
   // where to suppress (call-chain, library or module)
   /* TODO: must extend kmtrace first:
   KComboBox *suppressTypeCombo = new KComboBox( false, plainPage( ), "suppress type" );
   suppressTypeCombo->insertItem( i18n( "Library" ) );
   suppressTypeCombo->insertItem( i18n( "Module" ) );
   suppressTypeCombo->insertItem( i18n( "Call chain" ) );
   
   QLabel *suppressTypeLabel = new QLabel( suppressTypeCombo, i18n( "&Where to suppress:" ), plainPage( ) );
   topLayout->addWidget( suppressTypeLabel, 2, 0 );
   topLayout->addWidget( suppressTypeCombo, 2, 1 );
   */   
   
   textCombo = new KHistoryCombo( page, "text"  );

   connect( textCombo, SIGNAL( textChanged( const QString & ) ),
            this, SLOT( textSuppressChanged( const QString & ) ) );
   
   QLabel *textComboLabel = new QLabel( textCombo, i18n( "&Where to suppress:" ), page );
   topLayout->addWidget( textComboLabel, 2, 0 );
   topLayout->addWidget( textCombo, 2, 1 ); 
   
   enableButton( KDialogBase::User1, !textCombo->currentText( ).isEmpty( ) );
   
   if( !modal ) {
      connect( this, SIGNAL( closeClicked( ) ), this, SLOT( slotCancel ) );
   }

   setLeak( leak );
}

void KMtraceSuppressDialog::textSuppressChanged( const QString &text )
{
   enableButton( KDialogBase::User1, !text.isEmpty( ) );
}
     
void KMtraceSuppressDialog::slotUser1( void )
{
   if( !textCombo->currentText( ).isEmpty( ) ) {
      emit suppress( leak, textCombo->currentText( ) );
   }
}

void KMtraceSuppressDialog::slotCancel( void )
{
   emit done( );
   textCombo->clearEdit( );
   KDialogBase::slotCancel( );
}

QString KMtraceSuppressDialog::getText( ) const
{
   return textCombo->currentText( );
}

void KMtraceSuppressDialog::setText( QString string )
{
   textCombo->setEditText( string );
   textCombo->lineEdit( )->selectAll( );
}

void KMtraceSuppressDialog::setLeak( KMtraceLeak *leak )
{
   this->leak = leak;

   textCombo->clearHistory( );

   if( leak == 0 ) {
      return;
   }
   
   // try to guess a good suppress string
   QObjectList *callStack = leak->getCallStack( );
   QObjectListIt callIterator( *callStack );
   QObject *obj2;
   while( ( obj2 = callIterator.current( ) ) != 0 ) {
      KMtraceCall *call = (KMtraceCall *)obj2;
      QString func = call->getFunction( );
      QString addr = call->getAddress( );
      if( !addr.isEmpty( ) ) {
         setText( func );
         textCombo->addToHistory( func );
      }
      ++callIterator;
   }
}

