#ifndef __KMTRACE_SUPPRESS_DIALOG__HH__
#define __KMTRACE_SUPPRESS_DIALOG__HH__

// KDE includes
#include <kdialogbase.h>
#include <kcombobox.h>

// kmtraceviewer includes
#include "KMtraceLeak.hh"

class KMtraceSuppressDialog : public KDialogBase
{
   Q_OBJECT
   
   public:
      KMtraceSuppressDialog( KMtraceLeak *leak,
                             QWidget *parent = 0,
                             const char *name = 0,
                             bool modal = true );
      void setLeak( KMtraceLeak *leak );
      QString getText( ) const;
      void setText( QString string );

   protected:
      KMtraceLeak *leak;
      KHistoryCombo *textCombo;
   
   protected slots:
      void slotUser1( void );
      void slotCancel( void );
      void textSuppressChanged ( const QString & );

   signals:
      void suppress( KMtraceLeak *leak, QString string );
      void done( );
      
   private:
      virtual void done( int i ) { KDialogBase::done( i ); }
};

#endif
