#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

// KMtraceViewer includes
#include "KMtraceViewerMainWindow.hh"


// the name of the package (used in about dialog)
static const char *project_name = PACKAGE;

// the PRCS version (used in about dialog) 
static const char *project_version = PACKAGE_VERSION;

// home base of the tool
static const char *project_url = "http://kmtraceviewer.sourceforge.net";

static const KCmdLineOptions options[] =
{
   { "+[tree-file]", I18N_NOOP( "File containing the output of kmtrace." ), 0 },
   { 0, 0, 0 }
};

int main( int argc, char *argv[] )
{
   const char *ktreefile = 0;

   // create information for the about dialog
   KAboutData aboutData( project_name,
                         I18N_NOOP( project_name ), project_version,
                         I18N_NOOP( "GUI client for kmtrace (memory leak tracker)" ),
                         KAboutData::License_GPL,
                         "(C) 2002, Andreas Baumann",
                         I18N_NOOP( "Graphical user interface for the command "
                                    "line memory leak tracker kmtrace." ),
                         project_url );
   aboutData.addAuthor( "Andreas Baumann", 0,
                        PACKAGE_BUGREPORT, 0 );
   
   // parse command line arguments
   KCmdLineArgs::init( argc, argv, &aboutData );
   KCmdLineArgs::addCmdLineOptions( options );
   KCmdLineArgs *args = KCmdLineArgs::parsedArgs( );

   // read the name of a kmtrace output file (a kmtrace tree)
   if( args->count( ) > 0 ) {
      ktreefile = args->arg( 0 );
   }

   // new KDE application
   KApplication a;
   
   // either restore the main window (with its internal state) or create
   // a new one with default values
   if( a.isRestored( ) ) {
      RESTORE( KMtraceViewerMainWindow );
   } else {
      KMtraceViewerMainWindow *w = new KMtraceViewerMainWindow( ktreefile );
      a.setMainWidget( w );
      w->show( );
   }
   
   // start the KDE application
   return a.exec( );
}
