/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "document.h"
#include "parameter.h"
#include "result.h"
#include "datatype.h"

// command includes
#include "appendtovariablecommand.h"
#include "loadfromvariablewidget.h"
#include "changevariablecommand.h"

using namespace WorKflow;

AppendToVariableCommand::AppendToVariableCommand(Document* parent, CommandDescription* description)
  : ChangeVariableCommand(parent, description)
{
  LoadFromVariableWidget* w = new LoadFromVariableWidget(this);
  setWidget(w);
}

AppendToVariableCommand::~AppendToVariableCommand()
{
}

void AppendToVariableCommand::execute()
{
  QString varname = value("variable").nextString();

  Value in = value("input");
  Value val = document()->variable(varname);
  QStringList items = val.convertTo(in.type()).asStringList();
  items += in.asStringList();
  Value newVal = Value::stringList(val.type()->id(), items);

  document()->setVariable(varname, newVal);

  setResult("original", val);
  setResult("contents", newVal);

  Command::execute();
}

void AppendToVariableCommand::typeCheck(Result* prev)
{
  Command::typeCheck(prev);

  QString varname = value("variable").nextString();

  ChangeVariableCommand* var = 0;
  Datatype* outtype = 0;

  // find last "Store in variable" command which stores in varname
  for (int i = 0; i != row(); ++i) {
    Command* cmd = document()->commandAt(i);
    if (i != 0 && cmd->inherits("ChangeVariableCommand")) {
      ChangeVariableCommand* varcmd = static_cast<ChangeVariableCommand*>(cmd);
      if (varcmd->variableName() == varname) {
        var = varcmd;
        Command* before = document()->commandAt(i - 1);
        if (before->output())
          outtype = before->output()->type();
      }
    }
  }

  Datatype* intype = input()->type();
  if (!var || !outtype) {
    input()->setProblem(Slot::MissingInput);
    result("contents")->setProblem(Slot::MissingInput);
  } else if (!outtype->inherits(intype) || !outtype->isConvertibleTo(intype)) {
    input()->setProblem(Slot::TypeMismatch);
  } else {
//     result("contents")->setType(intype->id());
    result("original")->setType(outtype->id());
  }
}

#include "appendtovariablecommand.moc"
